import React, { useState, useEffect } from "react";
import Link from "next/link";

import logoTwoImg from "../../../public/assets/images/resources/logo-two.png";
import LogoPng from "../../../public/assets/images/resources/logo.png";
import shapeUnionPng from "../../../public/assets/images/shapes/union.png";
import WOW from "wowjs";
import { useRouter } from "next/navigation";

function Main() {
  const [showHome, setshowHome] = useState(false);
  const [showPage, setshowpage] = useState(false);
  const [showServices, setshowservices] = useState(false);
  const [showShop, setshowShop] = useState(false);
  const [showBlog, setshowBlog] = useState(false);

  const location = useRouter();
  const path = location.pathname;
  const [menu, setmenu] = useState({});
  const activeMenu = () => {
    if (path === "/" || path === "/") {
      setmenu({ home: true });
    } else if (path === "/page" || path === "/page") {
      setmenu({ Page: true });
    } else if (path === "/services" || path === "/services") {
      setmenu({ services: true });
    } else if (path === "/shop" || path === "/shop") {
      setmenu({ shop: true });
    } else if (path === "/blog" || path === "/blog") {
      setmenu({ blog: true });
    }
  };

  const [isSticky, setIsSticky] = useState(false);

  useEffect(() => {
    const handleScroll = () => {
      const offset = window.scrollY;
      if (offset > 100) {
        setIsSticky(true);
      } else {
        setIsSticky(false);
      }
    };

    window.addEventListener("scroll", handleScroll);

    return () => {
      window.removeEventListener("scroll", handleScroll);
    };
  }, []);

  useEffect(() => {
    window.scroll(0, 0);
    new WOW.WOW({
      live: false,
    }).init();
    activeMenu();
  }, [path]);
  const issticky = () => {
    const scrollTop = window.scrollY;
    scrollTop >= 141 ? setIsSticky(true) : setIsSticky(false);
  };

  const [mobileMenuOpen, setMobileMenuOpen] = useState(false);

  const toggleMobileMenu = () => {
    setMobileMenuOpen(!mobileMenuOpen);
  };

  const closeMenu = () => {
    setMobileMenuOpen(false);
  };

  return (
    <div>
      <header
        className={`main-header main-header-three ${
          isSticky ? "sticky-header--cloned sticky-fixed" : "sticky-header"
        }`}
      >
        <div className="container-fluid">
          <nav className="main-menu-three">
            <div className="header-three-left">
              <Link
                href="#"
                className="header-three-menu"
                onClick={toggleMobileMenu}
              >
                <img src={shapeUnionPng.src} alt="union" />
              </Link>
            </div>
            <div className="main-menu-logo">
              <Link href="/">
                <img src={logoTwoImg.src} alt="header-logo" />
              </Link>
            </div>
            <div className="main-menu-three-left-box">
              <div className="main-menu-three-search-box">
                <form>
                  <i className="icon-search" />
                  <input type="text" placeholder="Search" />
                </form>
              </div>
              <div className="main-menu-three-plus-box">
                <button>
                  <i className="icon-plus" />
                </button>
              </div>
            </div>
          </nav>
        </div>
      </header>

      {mobileMenuOpen && (
        <div className={`mobile-nav-wrapper ${mobileMenuOpen && "expanded"}`}>
          <div className="mobile-nav-overlay mobile-nav-toggler" />
          <div className="mobile-nav-content">
            <Link
              href="#"
              onClick={() => setMobileMenuOpen(false)}
              className="mobile-nav-close mobile-nav-toggler"
            >
              <span />
              <span />
            </Link>
            <div className="logo-box">
              <Link href="/">
                <img src={LogoPng.src} alt="logo" />
              </Link>
            </div>
            <div className="mobile-nav-container">
              <ul className="mobile-menu-list">
                <li className="menu-item-has-children dropdown">
                  <Link href="#" className={showHome ? "expanded" : ""}>
                    Home
                    <button onClick={() => setshowHome(!showHome)}>
                      <i
                        className={
                          showHome ? "fa fa-angle-left" : "fa fa-angle-down"
                        }
                      />
                    </button>
                  </Link>
                  <ul style={{ display: showHome ? "block" : "none" }}>
                    <li>
                      <Link href="/">Home One</Link>
                    </li>
                    <li>
                      <Link href="/hometwo">Home Two</Link>
                    </li>
                    <li>
                      <Link href="/homethree">Home Three</Link>
                    </li>
                    <li>
                      <Link href="/homefour">Home Four</Link>
                    </li>
                    <li>
                      <Link href="/homefive">Home Five</Link>
                    </li>
                  </ul>
                </li>
                <li className="menu-item-has-children dropdown">
                  <Link href="#" className={showPage ? "expanded" : ""}>
                    Page
                    <button onClick={() => setshowpage(!showPage)}>
                      <i
                        className={
                          showPage ? "fa fa-angle-left" : "fa fa-angle-down"
                        }
                      />
                    </button>
                  </Link>
                  <ul style={{ display: showPage ? "block" : "none" }}>
                    <li>
                      <Link href="/about">About</Link>
                    </li>
                    <li className="menu-item-has-children dropdown">
                      <Link href="#">Projects</Link>
                      <ul>
                        <li>
                          <Link href="/projects">Popular Projects</Link>
                        </li>
                        <li>
                          <Link href="/project-details">Project Details</Link>
                        </li>
                      </ul>
                    </li>
                    <li>
                      <Link href="/team-member">Team</Link>
                    </li>
                    <li>
                      <Link href="/package">Package</Link>
                    </li>
                    <li>
                      <Link href="/faq">FAQs</Link>
                    </li>
                  </ul>
                </li>
                <li className="menu-item-has-children dropdown">
                  <Link href="#" className={showServices ? "expanded" : ""}>
                    Services
                    <button onClick={() => setshowservices(!showServices)}>
                      <i
                        className={
                          showServices ? "fa fa-angle-left" : "fa fa-angle-down"
                        }
                      />
                    </button>
                  </Link>
                  <ul style={{ display: showServices ? "block" : "none" }}>
                    <li>
                      <Link href="/service">Popular Services</Link>
                    </li>
                    <li>
                      <Link href="/services-details">SEO Services</Link>
                    </li>
                    <li>
                      <Link href="/digital-market">Digital Marketing</Link>
                    </li>
                  </ul>
                </li>
                <li className="menu-item-has-children dropdown">
                  <Link href="#" className={showShop ? "expanded" : ""}>
                    Shop
                    <button onClick={() => setshowShop(!showShop)}>
                      <i
                        className={
                          showShop ? "fa fa-angle-left" : "fa fa-angle-down"
                        }
                      />
                    </button>
                  </Link>
                  <ul style={{ display: showShop ? "block" : "none" }}>
                    <li>
                      <Link href="/shop">Shop Page</Link>
                    </li>
                    <li>
                      <Link href="/shop-details">Product Deatils</Link>
                    </li>
                    <li>
                      <Link href="/cart">Cart</Link>
                    </li>
                    <li>
                      <Link href="/checkout">Checkout</Link>
                    </li>
                  </ul>
                </li>
                <li className="menu-item-has-children dropdown">
                  <Link href="#" className={showBlog ? "expanded" : ""}>
                    Blog
                    <button onClick={() => setshowBlog(!showBlog)}>
                      <i
                        className={
                          showBlog ? "fa fa-angle-left" : "fa fa-angle-down"
                        }
                      />
                    </button>
                  </Link>
                  <ul style={{ display: showBlog ? "block" : "none" }}>
                    <li>
                      <Link href="/blog">Blog List</Link>
                    </li>
                    <li>
                      <Link href="/blog-details">Blog Details</Link>
                    </li>
                  </ul>
                </li>
                <li>
                  <Link href="/contact">Contact</Link>
                </li>
              </ul>
            </div>
            <ul className="mobile-nav-contact list-unstyled">
              <li>
                <i className="fa fa-phone" />
                <Link href="/tel:+8898006802">+91 6353967672</Link>
              </li>
              <li>
                <i className="fa fa-envelope" />
                <Link href="/mailto:info@zoso.com">info@zoso.com</Link>
              </li>
            </ul>
            <ul className="mobile-nav-social">
              <li>
                <Link href="#">
                  <i className="icon-facebook-f" />
                </Link>
              </li>
              <li>
                <Link href="#">
                  <i className="icon-twitter" />
                </Link>
              </li>
              <li>
                <Link href="#">
                  <i className="icon-instagram" />
                </Link>
              </li>
              <li>
                <Link href="#">
                  <i className="icon-linkedin-in" />
                </Link>
              </li>
            </ul>
          </div>
        </div>
      )}
    </div>
  );
}

export default Main;
