"use client";
import Link from "next/link";
import TeamMemberOneImg1 from "../../../public/assets/images/team/team-member-one-1.jpg";
import TeamMemberOneImg2 from "../../../public/assets/images/team/team-member-one-2.jpg";
import TeamMemberOneImg3 from "../../../public/assets/images/team/team-member-one-3.jpg";
import TeamMemberOneImg4 from "../../../public/assets/images/team/team-member-one-4.jpg";

function TeamMemberOne() {
  const teamMembers = [
    {
      name: "Mathew R. Rosales",
      role: "CEO & Founder",
      image: TeamMemberOneImg1,
    },
    {
      name: "William I. Miranda",
      role: "Digital Marketer",
      image: TeamMemberOneImg2,
    },
    {
      name: "Lawrence K. McAllis",
      role: "Web Designer",
      image: TeamMemberOneImg3,
    },
    {
      name: "Richard T. Swafford",
      role: "SR Manager",
      image: TeamMemberOneImg4,
    },
  ];

  return (
    <div>
      <section className="team-member-one">
        <div className="container">
          <div className="team-member-one-title-box">
            <div className="section-four-title">
              <div
                className="section-four-title-title text-center wow fadeInUp animated"
                data-wow-duration="1500ms"
                data-wow-delay="100ms"
              >
                <h2>We Have 1562+ Experience Team Meet Our Team Members</h2>
              </div>
            </div>
            <div
              className="section-four-details text-center wow fadeInUp animated"
              data-wow-duration="1500ms"
              data-wow-delay="300ms"
            >
              <p>
                Digital marketing &amp; advertising approach focuses on
                capturing the essential
              </p>
            </div>
          </div>
          <div className="row">
            {teamMembers.map((member, index) => (
              <div key={index} className="col-xl-3 col-lg-3 col-md-3 col-sm-6">
                <div
                  className="team-member-one-single-box wow fadeInUp animated"
                  data-wow-duration="1500ms"
                  data-wow-delay={`${100 * index}ms`}
                >
                  <div className="team-member-one-single-img">
                    <div className="tiles">
                      <img
                        className="tile"
                        data-scale="1.15"
                        src={member.image.src}
                        alt={`team${index + 1}`}
                      />
                    </div>
                    <div className="team-member-one-single-img-tag">
                      <i className="icon-plus-2" />
                      <ul className="team-member-social">
                        <li>
                          <Link href="/#">
                            <i className="icon-facebook-f" />
                          </Link>
                        </li>
                        <li>
                          <Link href="/#">
                            <i className="icon-twitter" />
                          </Link>
                        </li>
                        <li>
                          <Link href="/#">
                            <i className="icon-instagram" />
                          </Link>
                        </li>
                        <li>
                          <Link href="/#">
                            <i className="icon-linkedin-in" />
                          </Link>
                        </li>
                      </ul>
                    </div>
                  </div>
                  <h4 className="team-member-one-single-title">
                    <Link href="/team-member">{member.name}</Link>
                  </h4>
                  <p className="team-member-one-single-detail">{member.role}</p>
                </div>
              </div>
            ))}
          </div>
        </div>
      </section>
    </div>
  );
}

export default TeamMemberOne;
