"use client";
import Link from "next/link";
import cardProductImg1 from "../../../public/assets/images/shop/cart-product-img-1.png";
import cardProductImg2 from "../../../public/assets/images/shop/cart-product-img-2.png";

function CardDetails() {
  const products = [
    {
      name: "Summer M T-Shirt",
      price: "$25.00",
      quantity: 2,
      subtotal: "$50.00",
      image: cardProductImg1,
    },
    {
      name: "Leather Bag",
      price: "$13.00",
      quantity: 3,
      subtotal: "$39.00",
      image: cardProductImg2,
    },
  ];

  return (
    <div>
      <section className="cart-details">
        <div className="container">
          <div
            className="cart-box wow fadeInUp animated"
            data-wow-duration="1500ms"
            data-wow-delay="00ms"
          >
            <div
              className="cart-title-box wow fadeInUp animated"
              data-wow-duration="1500ms"
              data-wow-delay="100ms"
            >
              <div className="row">
                <div className="col-6">
                  <div className="cart-product-title">
                    <h4>Product</h4>
                  </div>
                </div>
                <div className="col-6">
                  <div className="row">
                    <div className="col-4">
                      <div className="cart-product-price">
                        <h4>Price</h4>
                      </div>
                    </div>
                    <div className="col-4">
                      <div className="cart-product-quantity">
                        <h4>Quantity</h4>
                      </div>
                    </div>
                    <div className="col-4">
                      <div className="cart-product-subtotal">
                        <h4>Subtotal</h4>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
            </div>
            <div className="cart-product-box">
              {products.map((product, index) => (
                <div
                  key={index}
                  className="cart-product-single-box wow fadeInUp animated"
                  data-wow-duration="1500ms"
                  data-wow-delay={`${300 + index * 200}ms`}
                >
                  <div className="row align-items-center">
                    <div className="col-xl-3 col-lg-3 col-md-6 col-sm-6">
                      <div className="row align-items-center">
                        <div className="col-12">
                          <div className="cart-product-img-box">
                            <div className="cart-product-remove">
                              <Link href="#">
                                <i className="icon icon-clos" />
                              </Link>
                            </div>
                            <div className="cart-product-img">
                              <img
                                src={product.image.src}
                                alt={`cart-product-img-${index + 1}`}
                              />
                            </div>
                          </div>
                        </div>
                      </div>
                    </div>
                    <div className="col-xl-9 col-lg-9 col-md-6 col-sm-6">
                      <div className="row align-items-center">
                        <div className="col-xl-4 col-lg-6 col-md-12 col-sm-12">
                          <div className="cart-product-name">
                            <h4>{product.name}</h4>
                          </div>
                        </div>
                        <div className="col-xl-3 col-lg-2 col-md-4 col-sm-12 col-4">
                          <div className="cart-product-price">
                            <h5>{product.price}</h5>
                          </div>
                        </div>
                        <div className="col-xl-2 col-lg-2 col-md-4 col-sm-12 col-4">
                          <div className="cart-product-quantity">
                            <h5>{product.quantity}</h5>
                          </div>
                        </div>
                        <div className="col-xl-3 col-lg-2 col-md-4 col-sm-12 col-4">
                          <div className="cart-product-subtotal">
                            <h5>{product.subtotal}</h5>
                          </div>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
              ))}
              <div
                className="cart-product-btn-box wow fadeInUp animated"
                data-wow-duration="1500ms"
                data-wow-delay="700ms"
              >
                <div className="row align-items-center">
                  <div className="col-xl-5 col-lg-6 col-md-7 col-sm-12">
                    <form action="#" className="cart-product-coupon-box">
                      <input type="text" placeholder="Coupon Code" />
                      <button className="coupon-btn main-btn thm-btn">
                        Apply Code
                        <i className="icon-right-arrow" />
                      </button>
                    </form>
                  </div>
                  <div className="col-xl-7 col-lg-6 col-md-5 col-sm-12">
                    <div className="cart-product-coupon-btn">
                      <button className="coupon-btn main-btn thm-btn">
                        Apply Code
                        <i className="icon-right-arrow" />
                      </button>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
          <div className="cart-total">
            <div className="row">
              <div className="col-xl-7 col-lg-6 col-md-4 col-sm-12" />
              <div className="col-xl-5 col-lg-6 col-md-8 col-sm-12">
                <div
                  className="cart-total-box wow fadeInUp animated"
                  data-wow-duration="1500ms"
                  data-wow-delay="100ms"
                >
                  <h4>Cart Totals</h4>
                  <div className="cart-total-detail">
                    <div className="cart-total-detail-subtotal">
                      <h5>Subtotal</h5>
                      <h5>$89.00</h5>
                    </div>
                    <div className="cart-total-detail-total">
                      <h5>Total</h5>
                      <h5>$89.00</h5>
                    </div>
                  </div>
                  <div className="cart-total-box-btn">
                    <Link href="/cart" className="coupon-btn main-btn thm-btn">
                      Record to Checkout
                      <i className="icon-right-arrow" />
                    </Link>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </section>
    </div>
  );
}

export default CardDetails;
