"use client";
import Link from "next/link";
import productImg4 from "../../../public/assets/images/shop/product-4.png";
import productImg5 from "../../../public/assets/images/shop/product-5.png";
import productImg6 from "../../../public/assets/images/shop/product-6.png";
import productImg7 from "../../../public/assets/images/shop/product-7.png";

function ShopDetails() {
  const products = [
    { img: productImg4, title: "Women Leather Bag", price: "$13.00" },
    { img: productImg5, title: "Women Leather Bag", price: "$13.00" },
    { img: productImg6, title: "Women Leather Bag", price: "$13.00" },
    { img: productImg7, title: "Men Leather Shoe", price: "$13.00" },
  ];

  return (
    <div>
      <section className="shop-details">
        <div className="container">
          <div className="related-products">
            <div className="section-main-title text-center">
              <h2 className="mx-auto">Related Products</h2>
            </div>
            <div className="row">
              {products.map((product, index) => (
                <div
                  key={index}
                  className="col-lg-3 col-md-6 col-sm-12 wow fadeInRight animated"
                  data-wow-duration="1500ms"
                  data-wow-delay={`${100 + index * 200}ms`}
                >
                  <div className="product-box">
                    <div className="product-img">
                      <img src={product.img.src} alt={`product-${index + 1}`} />
                      <div className="product-inner-box">
                        <div className="product-add-btn">
                          <Link href="/checkout" className="thm-btn main-btn">
                            Add to Cart
                            <i className="icon-right-arrow" />
                          </Link>
                        </div>
                      </div>
                    </div>
                    <div className="product-rating-star">
                      {[...Array(5)].map((_, i) => (
                        <i key={i} className="fas fa-star" />
                      ))}
                    </div>
                    <div className="product-title">
                      <h5>
                        <Link href="#">{product.title}</Link>
                      </h5>
                    </div>
                    <div className="product-price">
                      <h6>{product.price}</h6>
                    </div>
                  </div>
                </div>
              ))}
            </div>
          </div>
        </div>
      </section>
    </div>
  );
}

export default ShopDetails;
