import React,{useState} from "react";

function FaqAccordion({ title, content }) {
  const [isActive, setisActive] = useState(false);
  return (
    <div
      className="accordion-item wow fadeInLeft animated animated"
      data-wow-duration="1500ms"
      data-wow-delay="100ms"
      style={{
        visibility: "visible",
        animationDuration: "1500ms",
        animationDelay: "100ms",
        animationName: "fadeInLeft",
      }}
    >
      {/* accordion-header */}
      <h6 className="accordion-header" id="flush-headingOne">
        <button
          className={isActive?"accordion-button":"accordion-button collapsed"}
          type="button"
          onClick={()=>setisActive(!isActive)}
          data-bs-toggle="collapse"
          data-bs-target="#flush-collapseOne"
          aria-expanded="true"
          aria-controls="flush-collapseOne"
        >
          {title}
          <i className="icon-arrow-2" />
        </button>
      </h6>
      {/* accordion-collapse */}
      <div
        id={`flush-collapse`}
        className={isActive?"accordion-collapse collapse show":"accordion-collapse collapse"}
        aria-labelledby="flush-headingOne"
        data-bs-parent="#accordionFlushExample"
      >
        <div className="accordion-body">
          <p>{content}</p>
        </div>
      </div>
    </div>
  );
}

export default FaqAccordion;
