import React, { useState } from 'react';

function FaqBox() {
  const [activeSection, setActiveSection] = useState(0);

  const handleToggleSection = (sectionIndex) => {
    setActiveSection(activeSection === sectionIndex ? null : sectionIndex);
  };

  const faqData = [
    {
      title: "Why Need Digital Marketing For Build Business ?",
      content:
        "Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitaedicta explicabo voluptatem quia voluptas sit aspernatur autodit aut fugit, sed quia consequuntur magni dolores",
    },
    {
      title: "How to Increase Web Traffic ?",
      content:
        "Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitaedicta explicabo voluptatem quia voluptas sit aspernatur autodit aut fugit, sed quia consequuntur magni dolores",
    },
    {
      title: "How to Development SEO Optimization ?",
      content:
        "Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitaedicta explicabo voluptatem quia voluptas sit aspernatur autodit aut fugit, sed quia consequuntur magni dolores",
    },
    {
      title: "Have Any Professional Team Member ?",
      content:
        "Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitaedicta explicabo voluptatem quia voluptas sit aspernatur autodit aut fugit, sed quia consequuntur magni dolores",
    },
    {
      title: "Have you any Global Customer ?",
      content:
        "Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitaedicta explicabo voluptatem quia voluptas sit aspernatur autodit aut fugit, sed quia consequuntur magni dolores",
    },
  ];

  return (
    <div>
      <section className="faq-box">
        <div className="container">
          <div className="faq-title-box">
            <div className="section-three-title wow fadeInUp animated" data-wow-duration="1500ms" data-wow-delay="100ms">
              <div className="section-three-title-title text-center">
                <h2>Frequently Asked Questions</h2>
              </div>
            </div>
            <div className="section-three-details text-center wow fadeInUp animated" data-wow-duration="1500ms" data-wow-delay="300ms">
              <p>Digital marketing &amp; advertising approach focuses on capturing the essential</p>
            </div>
          </div>
          <div className="faq-inner">
            <div className="accordion accordion-flush" id="accordionFlushExample">
              {faqData.map((item, index) => (
                <div key={index} className={`accordion-item wow fadeInLeft animated`} data-wow-duration="1500ms" data-wow-delay={`${100 * index}ms`}>
                  <h6 className="accordion-header" id={`flush-heading${index}`}>
                    <button
                      className={`accordion-button ${activeSection === index ? '' : 'collapsed'}`}
                      type="button"
                      onClick={() => handleToggleSection(index)}
                      aria-expanded={activeSection === index ? 'true' : 'false'}
                      aria-controls={`flush-collapse${index}`}
                    >
                      {item.title}
                      <i className="icon-arrow-2" />
                    </button>
                  </h6>
                  <div
                    id={`flush-collapse${index}`}
                    className={`accordion-collapse collapse ${activeSection === index ? 'show' : ''}`}
                    aria-labelledby={`flush-heading${index}`}
                    data-bs-parent="#accordionFlushExample"
                  >
                    <div className="accordion-body">
                      <p>{item.content}</p>
                    </div>
                  </div>
                </div>
              ))}
            </div>
          </div>
        </div>
      </section>
    </div>
  );
}

export default FaqBox;
