import React, { useEffect, useState } from "react";
import CountUp from "react-countup";


function FactTwo() {

  const [isInitialized, setIsInitialized] = useState(false);

  useEffect(() => {
    setIsInitialized(true);
  }, []);


  return (
    <div>
      <section className="fact-two">
        <div className="container">
          <div className="fact-two-detail-box">
            <div className="row">
              <div className="col-xl-3 col-lg-3 col-md-6 col-sm-6 col-6">
                <div
                  className="fact-two-single wow fadeInLeft animated"
                  data-wow-duration="1500ms"
                  data-wow-delay="700ms"
                >
                  <div className="fact-two-single-top-icon fact-two-single-top-icon-one">
                    <i className="icon-layers1" />
                  </div>
                  <div className="fact-two-single-title">
                    <h2>
                      <span>
                        <CountUp
                          start={0}
                          end={256}
                          duration={2}
                        />
                      </span>
                      +
                    </h2>
                  </div>
                  <div className="fact-two-single-detail">
                    <p>Project Complete</p>
                  </div>
                  <div className="fact-two-single-bottom-icon fact-two-single-bottom-icon-one">
                    <i className="icon-Line" />
                  </div>
                </div>
              </div>
              <div className="col-xl-3 col-lg-3 col-md-6 col-sm-6 col-6">
                <div
                  className="fact-two-single wow fadeInLeft animated"
                  data-wow-duration="1500ms"
                  data-wow-delay="500ms"
                >
                  <div className="fact-two-single-top-icon fact-two-single-top-icon-two">
                    <i className="icon-loyal-customer" />
                  </div>
                  <div className="fact-two-single-title">
                    {isInitialized && (
                      <h2>
                        <span>
                          <CountUp
                            start={0}
                            end={85}
                            duration={2}
                          />
                        </span>
                        k+
                      </h2>
                    )}
                  </div>
                  <div className="fact-two-single-detail">
                    <p>Satisfied Customers</p>
                  </div>
                  <div className="fact-two-single-bottom-icon fact-two-single-bottom-icon-two">
                    <i className="icon-Line" />
                  </div>
                </div>
              </div>
              <div className="col-xl-3 col-lg-3 col-md-6 col-sm-6 col-6">
                <div
                  className="fact-two-single wow fadeInLeft animated"
                  data-wow-duration="1500ms"
                  data-wow-delay="300ms"
                >
                  <div className="fact-two-single-top-icon fact-two-single-top-icon-three">
                    <i className="icon-positive-thinking1" />
                  </div>
                  <div className="fact-two-single-title">
                    {isInitialized && (
                      <h2>
                        <span>
                          <CountUp
                            start={0}
                            end={95}
                            duration={2}
                          />
                        </span>
                        %
                      </h2>
                    )}
                  </div>
                  <div className="fact-two-single-detail">
                    <p>Positive Reviews</p>
                  </div>
                  <div className="fact-two-single-bottom-icon fact-two-single-bottom-icon-three">
                    <i className="icon-Line" />
                  </div>
                </div>
              </div>
              <div className="col-xl-3 col-lg-3 col-md-6 col-sm-6 col-6">
                <div
                  className="fact-two-single wow fadeInLeft animated"
                  data-wow-duration="1500ms"
                  data-wow-delay="100ms"
                >
                  <div className="fact-two-single-top-icon fact-two-single-top-icon-four">
                    <i className="icon-trophy2" />
                  </div>
                  <div className="fact-two-single-title">
                    {isInitialized && (
                      <h2>
                        <span>
                          <CountUp
                            start={0}
                            end={325}
                            duration={2}
                          />
                        </span>
                        +
                      </h2>
                    )}
                  </div>
                  <div className="fact-two-single-detail">
                    <p>Awards Winning</p>
                  </div>
                  <div className="fact-two-single-bottom-icon fact-two-single-bottom-icon-four">
                    <i className="icon-Line" />
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </section>
    </div>
  );
}

export default FactTwo;
