import React, { useEffect, useState } from "react";
import CountUp from "react-countup";
import Process1 from "../../../public/assets/images/shapes/process-one-shape-1.png";
import Process2 from "../../../public/assets/images/shapes/process-one-shape-2.png";
import Process3 from "../../../public/assets/images/shapes/process-one-shape-3.png";
import Process4 from "../../../public/assets/images/shapes/process-one-shape-4.png";
import Process5 from "../../../public/assets/images/shapes/process-one-shape-5.png";

function ProcessOne() {
  const [isInitialized, setIsInitialized] = useState(false);

  useEffect(() => {
    setIsInitialized(true);
  }, []);

  return (
    <div>
      <section className="process-one">
        <div
          className="process-one-shape-1 wow fadeInLeft animated"
          data-wow-duration="1500ms"
          data-wow-delay="100ms"
        >
          <div className="animation_image_zoom">
            <div className="process-one-shape-1-img">
              <img src={Process1.src} alt="process-one-shape-1" />
            </div>
          </div>
        </div>
        <div
          className="process-one-shape-2 wow fadeInLeft animated"
          data-wow-duration="1500ms"
          data-wow-delay="100ms"
        >
          <div className="animation_image_zoom">
            <div className="process-one-shape-2-img">
              <img src={Process2.src} alt="process-one-shape-2" />
            </div>
          </div>
        </div>
        <div
          className="process-one-shape-3 wow fadeInDown animated"
          data-wow-duration="1500ms"
          data-wow-delay="100ms"
        >
          <div className="animation_image_zoom">
            <div className="process-one-shape-3-img">
              <img src={Process3.src} alt="process-one-shape-3" />
            </div>
          </div>
        </div>
        <div
          className="process-one-shape-4 wow fadeInRight animated"
          data-wow-duration="1500ms"
          data-wow-delay="100ms"
        >
          <div className="animation_image_zoom">
            <div className="process-one-shape-4-img">
              <img src={Process4.src} alt="process-one-shape-4" />
            </div>
          </div>
        </div>
        <div
          className="process-one-shape-5 wow fadeInRight animated"
          data-wow-duration="1500ms"
          data-wow-delay="100ms"
        >
          <div className="animation_image_zoom">
            <div className="process-one-shape-5-img">
              <img src={Process5.src} alt="process-one-shape-5" />
            </div>
          </div>
        </div>
        <div className="container">
          <div className="process-one-title">
            <div className="section-three-title text-center">
              <div
                className="section-three-title-text wow fadeInUp animated"
                data-wow-duration="1500ms"
                data-wow-delay="100ms"
              >
                <p>Working Process</p>
              </div>
              <div
                className="section-three-title-title wow fadeInUp animated"
                data-wow-duration="1500ms"
                data-wow-delay="300ms"
              >
                <h2>Working Process, How Does We Work</h2>
              </div>
            </div>
          </div>
          <div className="process-one-step">
            <div className="row">
              <div className="col-xl-3 col-lg-3 col-md-6 col-sm-12">
                <div
                  className="process-one-step-details wow fadeInLeft animated"
                  data-wow-duration="1500ms"
                  data-wow-delay="700ms"
                >
                  <span>Step 01</span>
                  <h5>Target Audience</h5>
                  <div className="process-one-step-details-icon process-one-step-one-details-icon">
                    <i className="icon icon-target" />
                  </div>
                  <p>
                    Sed pers unde omnis natus volupta accusantiuc dolorem
                    laudant totamem apere
                  </p>
                </div>
              </div>
              <div className="col-xl-3 col-lg-3 col-md-6 col-sm-12">
                <div
                  className="process-one-step-details wow fadeInLeft animated"
                  data-wow-duration="1500ms"
                  data-wow-delay="500ms"
                >
                  <span>Step 02</span>
                  <h5>Competitor Analysis</h5>
                  <div className="process-one-step-details-icon process-one-step-two-details-icon">
                    <i className="icon icon-startup" />
                  </div>
                  <p>
                    At vero eoset accusamus et odidignissimos ducimus quie
                    blanditiis praesentium
                  </p>
                </div>
              </div>
              <div className="col-xl-3 col-lg-3 col-md-6 col-sm-12">
                <div
                  className="process-one-step-details wow fadeInLeft animated"
                  data-wow-duration="1500ms"
                  data-wow-delay="300ms"
                >
                  <span>Step 03</span>
                  <h5>Strategy &amp; Execution</h5>
                  <div className="process-one-step-details-icon process-one-step-three-details-icon">
                    <i className="icon icon-idea1" />
                  </div>
                  <p>
                    At vero eoset accusamus et odidignissimos ducimus quie
                    blanditiis praesentium
                  </p>
                </div>
              </div>
              <div className="col-xl-3 col-lg-3 col-md-6 col-sm-12">
                <div
                  className="process-one-step-details wow fadeInLeft animated"
                  data-wow-duration="1500ms"
                  data-wow-delay="100ms"
                >
                  <span>Step 04</span>
                  <h5>3x Results</h5>
                  <div className="process-one-step-details-icon process-one-step-four-details-icon">
                    <i className="icon icon-trophy2" />
                  </div>
                  <p>
                    At vero eoset accusamus et odidignissimos ducimus quie
                    blanditiis praesentium
                  </p>
                </div>
              </div>
            </div>
          </div>
          <div className="row">
            <div className="col-xl-6 col-lg-12 col-md-12 col-sm-12">
              <div className="process-one-bottom-left-box">
                <div className="section-three-title">
                  <div
                    className="section-three-title-text wow fadeInLeft animated"
                    data-wow-duration="1500ms"
                    data-wow-delay="100ms"
                  >
                    <p>Company Statistics</p>
                  </div>
                  <div
                    className="section-three-title-title wow fadeInLeft animated"
                    data-wow-duration="1500ms"
                    data-wow-delay="300ms"
                  >
                    <h2>
                      We’ve Achieve Lot’s Of Clients and Positive Feedback
                    </h2>
                  </div>
                </div>
                <div className="process-one-bottom-left-img-box">
                  <div className="process-one-bottom-left-img-box-shape-1" />
                  <div className="process-one-bottom-left-img-box-shape-2" />
                  <div className="row">
                    <div className="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-6">
                      <div
                        className="process-one-bottom-left-img-1 wow fadeInLeft animated"
                        data-wow-duration="1500ms"
                        data-wow-delay="500ms"
                      >
                        <img
                          src={require("../../../public/assets/images/resources/process-one-bottom-img-1.jpg")}
                          alt="process-one-bottom-img-1"
                        />
                      </div>
                    </div>
                    <div className="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-6">
                      <div
                        className="process-one-bottom-left-img-2 wow fadeInLeft animated"
                        data-wow-duration="1500ms"
                        data-wow-delay="300ms"
                      >
                        <img
                          src={require("../../../public/assets/images/resources/process-one-bottom-img-2.jpg")}
                          alt="process-one-bottom-img-2"
                        />
                      </div>
                    </div>
                  </div>
                </div>
              </div>
            </div>
            <div className="col-xl-6 col-lg-12 col-md-12 col-sm-12">
              <div className="process-one-bottom-right-box">
                {isInitialized && (
                  <div>
                    <div
                      className="process-one-bottom-right-info process-one-bottom-right-info-1 wow fadeInRight animated"
                      data-wow-duration="1500ms"
                      data-wow-delay="100ms"
                    >
                      <div className="process-one-bottom-right-info-icon">
                        <i className="icon icon-layers1" />
                      </div>
                      <h2>
                        <span>
                          <CountUp start={0} end={256} duration={2} />
                        </span>
                        +
                      </h2>
                      <p>Project Complete</p>
                    </div>
                    <div
                      className="process-one-bottom-right-info process-one-bottom-right-info-2 wow fadeInRight animated"
                      data-wow-duration="1500ms"
                      data-wow-delay="300ms"
                    >
                      <div className="process-one-bottom-right-info-icon">
                        <i className="icon icon-loyal-customer" />
                      </div>
                      <h2>
                        <span>
                          <CountUp start={0} end={85} duration={2} />
                        </span>
                        k+
                      </h2>
                      <p>Satisfied Customers</p>
                    </div>
                    <div
                      className="process-one-bottom-right-info process-one-bottom-right-info-3 wow fadeInRight animated"
                      data-wow-duration="1500ms"
                      data-wow-delay="500ms"
                    >
                      <div className="process-one-bottom-right-info-icon">
                        <i className="icon icon-positive-thinking1" />
                      </div>
                      <h2>
                        <span>
                          <CountUp start={0} end={93} duration={2} />
                        </span>
                        %
                      </h2>
                      <p>Positive Reviews</p>
                    </div>
                  </div>
                )}
              </div>
            </div>
          </div>
        </div>
      </section>
    </div>
  );
}

export default ProcessOne;
