"use client";
import Link from "next/link";
import "swiper/css";
import { Swiper, SwiperSlide } from "swiper/react";

const Caseslider = {
  autoplay: {
    delay: 1000,
  },
  responsive: [
    {
      breakpoint: 1024,
      settings: {
        slidesPerView: 2,
        slidesToScroll: 3,
        arrows: true,
      },
    },
    {
      breakpoint: 992,
      settings: {
        slidesPerView: 2,
        slidesToScroll: 3,
        arrows: false,
      },
    },
    {
      breakpoint: 740,
      settings: {
        slidesPerView: 1,
        slidesToScroll: 3,
        arrows: false,
      },
    },
    {
      breakpoint: 480,
      settings: {
        slidesPerView: 1,
        slide: 3,
        arrows: false,
      },
    },
  ],
};

function CaseOne() {
  return (
    <div>
      <section className="case-one">
        <div className="container-fluid">
          <div className="case-one-title-box">
            <div className="section-two-title text-center">
              <div
                className="section-two-title-text wow fadeInUp animated"
                data-wow-duration="1500ms"
                data-wow-delay="100ms"
              >
                <p>Latest Case Studies</p>
              </div>
              <div
                className="section-two-title-title wow fadeInUp animated"
                data-wow-duration="1500ms"
                data-wow-delay="300ms"
              >
                <h2>Popular Case Studies For Our Global Customers</h2>
              </div>
            </div>
          </div>
          <Swiper
            className="swiper-wrapper"
            slidesPerView={2}
            spaceBetween={30}
            autoplay={true}
            autoplayspeed={1000}
            {...Caseslider}
          >
            <SwiperSlide
              className="case-one-single wow fadeInRight animated"
              data-wow-duration="1500ms"
              data-wow-delay="100ms"
            >
              <div className="case-one-single-img-box">
                <img
                  src="../../../public/assets/images/resources/case-one-single-img-1.jpg"
                  alt="case-one-single-img-1"
                />
              </div>
              <div className="case-one-single-details-box">
                <div className="case-one-single-text">
                  <p>Product Sale</p>
                </div>
                <div className="case-one-single-title">
                  <h5>How To Grow sale and product marketing</h5>
                </div>
                <div className="case-one-single-btn">
                  <Link href="/project-details" className="read-more-btn">
                    Read More
                    <i className="icon-right-arrow" />
                  </Link>
                </div>
              </div>
            </SwiperSlide>
            <SwiperSlide
              className="case-one-single wow fadeInRight animated"
              data-wow-duration="1500ms"
              data-wow-delay="100ms"
            >
              <div className="case-one-single-img-box">
                <img
                  src={require("../../../public/assets/images/resources/case-one-single-img-2.jpg")}
                  alt="case-one-single-img-2"
                />
              </div>
              <div className="case-one-single-details-box">
                <div className="case-one-single-text">
                  <p>Product Sale</p>
                </div>
                <div className="case-one-single-title">
                  <h5>How To Grow sale and product marketing</h5>
                </div>
                <div className="case-one-single-btn">
                  <Link href="/project-details" className="read-more-btn">
                    Read More
                    <i className="icon-right-arrow" />
                  </Link>
                </div>
              </div>
            </SwiperSlide>
            <SwiperSlide
              className="case-one-single wow fadeInRight animated"
              data-wow-duration="1500ms"
              data-wow-delay="300ms"
            >
              <div className="case-one-single-img-box">
                <img
                  src={require("../../../public/assets/images/resources/case-one-single-img-3.jpg")}
                  alt="case-one-single-img-3"
                />
              </div>
              <div className="case-one-single-details-box">
                <div className="case-one-single-text">
                  <p>Product Sale</p>
                </div>
                <div className="case-one-single-title">
                  <h5>How To Grow sale and product marketing</h5>
                </div>
                <div className="case-one-single-btn">
                  <Link href="/project-details" className="read-more-btn">
                    Read More
                    <i className="icon-right-arrow" />
                  </Link>
                </div>
              </div>
            </SwiperSlide>
            <SwiperSlide
              className="case-one-single wow fadeInRight animated"
              data-wow-duration="1500ms"
              data-wow-delay="500ms"
            >
              <div className="case-one-single-img-box">
                <img
                  src={require("../../../public/assets/images/resources/case-one-single-img-1.jpg")}
                  alt="case-one-single-img-1"
                />
              </div>
              <div className="case-one-single-details-box">
                <div className="case-one-single-text">
                  <p>Product Sale</p>
                </div>
                <div className="case-one-single-title">
                  <h5>How To Grow sale and product marketing</h5>
                </div>
                <div className="case-one-single-btn">
                  <Link href="/project-details" className="read-more-btn">
                    Read More
                    <i className="icon-right-arrow" />
                  </Link>
                </div>
              </div>
            </SwiperSlide>
            <SwiperSlide
              className="case-one-single wow fadeInRight animated"
              data-wow-duration="1500ms"
              data-wow-delay="700ms"
            >
              <div className="case-one-single-img-box">
                <img
                  src={require("../../../public/assets/images/resources/case-one-single-img-2.jpg")}
                  alt="case-one-single-img-2"
                />
              </div>
              <div className="case-one-single-details-box">
                <div className="case-one-single-text">
                  <p>Product Sale</p>
                </div>
                <div className="case-one-single-title">
                  <h5>How To Grow sale and product marketing</h5>
                </div>
                <div className="case-one-single-btn">
                  <Link href="/project-details" className="read-more-btn">
                    Read More
                    <i className="icon-right-arrow" />
                  </Link>
                </div>
              </div>
            </SwiperSlide>
            <SwiperSlide
              className="case-one-single wow fadeInRight animated"
              data-wow-duration="1500ms"
              data-wow-delay="900ms"
            >
              <div className="case-one-single-img-box">
                <img
                  src={require("../../../public/assets/images/resources/case-one-single-img-3.jpg")}
                  alt="case-one-single-img-3"
                />
              </div>
              <div className="case-one-single-details-box">
                <div className="case-one-single-text">
                  <p>Product Sale</p>
                </div>
                <div className="case-one-single-title">
                  <h5>How To Grow sale and product marketing</h5>
                </div>
                <div className="case-one-single-btn">
                  <Link href="/project-details" className="read-more-btn">
                    Read More
                    <i className="icon-right-arrow" />
                  </Link>
                </div>
              </div>
            </SwiperSlide>
          </Swiper>
        </div>
      </section>
    </div>
  );
}

export default CaseOne;
