"use client";
import Link from "next/link";
import Service1 from "../../../public/assets/images/resources/service-one-img-1.png";
import Service2 from "../../../public/assets/images/resources/service-one-img-2.png";
import Service3 from "../../../public/assets/images/resources/service-one-img-3.png";
import Service4 from "../../../public/assets/images/resources/service-one-img-4.png";
import Service5 from "../../../public/assets/images/resources/service-one-img-5.png";
import Service6 from "../../../public/assets/images/resources/service-one-img-6.png";

const serviceData = [
  {
    imgSrc: Service1,
    title: "Increase Marketing and Add Chat List",
  },
  {
    imgSrc: Service2,
    title: "Content Marketing and Keyword Research",
  },
  {
    imgSrc: Service3,
    title: "Social Media Marketing and email Marketing",
  },
  {
    imgSrc: Service4,
    title: "Optimize Keywords and your Websites",
  },
  {
    imgSrc: Service5,
    title: "e-Commerce Enterprise Marketing Strategy",
  },
  {
    imgSrc: Service6,
    title: "SMS Marketing and Link Building Camping",
  },
];

function ServiceOne() {
  return (
    <div>
      <section className="service-one">
        <div className="service-one-shape-1" />
        <div className="service-one-shape-2" />
        <div className="service-one-shape-3" />
        <div className="service-one-shape-4" />
        <div className="container">
          <div
            className="section-title text-center wow fadeInUp animated"
            data-wow-duration="1500ms"
            data-wow-delay="100ms"
          >
            <h2>Effective Marketing and Generate more leads than ever</h2>
          </div>
          <div
            className="section-details text-center wow fadeInUp animated"
            data-wow-duration="1500ms"
            data-wow-delay="300ms"
          >
            <p>
              Digital marketing &amp; advertising approach focuses on capturing
              the essential
            </p>
          </div>
          <div className="service-one-info">
            <div className="row">
              {serviceData.map((service, index) => (
                <div
                  key={index}
                  className="col-xl-4 col-lg-4 col-md-6 col-sm-12"
                >
                  <div
                    className={`service-one-box service-one-box-${
                      index + 1
                    } wow fadeInUp animated`}
                    data-wow-duration="1500ms"
                    data-wow-delay={`${100 * (index + 1)}ms`}
                  >
                    <div className="service-one-img-box">
                      <img
                        src={service.imgSrc.src}
                        alt={`service-one-img-${index + 1}`}
                      />
                    </div>
                    <div className="service-one-title-box">
                      <h3>{service.title}</h3>
                    </div>
                    <div className="service-one-btn-box">
                      <Link href="/services-details" className="read-more-btn">
                        Read More
                        <i className="icon-right-arrow" />
                      </Link>
                    </div>
                  </div>
                </div>
              ))}
            </div>
          </div>
        </div>
      </section>
    </div>
  );
}

export default ServiceOne;
