import React, { useState } from "react";
import Link from "next/link";
import Shopdtlsimg1 from "../../../public/assets/images/shop/product-1.png";
import Shopdtlsimg2 from "../../../public/assets/images/shop/product-2.png";
import Shopdtlsimg3 from "../../../public/assets/images/shop/product-3.png";
import Shopdtlsimg4 from "../../../public/assets/images/shop/product-4.png";
import Shopdtlsimg5 from "../../../public/assets/images/shop/product-5.png";
import Shopdtlsimg6 from "../../../public/assets/images/shop/product-6.png";
import Shopdtlsimg7 from "../../../public/assets/images/shop/product-7.png";
import Blogimg1 from "../../../public/assets/images/blog/comment-1-1.jpg";
import Blogimg2 from "../../../public/assets/images/blog/comment-1-2.jpg";

function ShopDetails() {
  const [showDesc, setshowDesc] = useState(true);
  const [showReview, setshowReview] = useState(false);
  const [showAdditon, setshowAdditon] = useState(false);

  return (
    <div>
      <section className="shop-details">
        <div className="container">
          <div className="product-single">
            <div className="row">
              <div className="col-lg-6 col-md-12 col-sm-12">
                <div className="product-single-left">
                  <div
                    className="product-single-left-img wow fadeInLeft animated"
                    data-wow-duration="1500ms"
                    data-wow-delay="200ms"
                  >
                    <img src={Shopdtlsimg1.src} alt="product-1" />
                  </div>
                  <div className="product-single-left-bottom">
                    <div className="row">
                      <div
                        className="col-4 wow fadeInLeft animated"
                        data-wow-duration="1500ms"
                        data-wow-delay="600ms"
                      >
                        <div className="product-single-left-bottom-img">
                          <Link href="#">
                            <img src={Shopdtlsimg2.src} alt="product-6" />
                          </Link>
                        </div>
                      </div>
                      <div
                        className="col-4 wow fadeInLeft animated"
                        data-wow-duration="1500ms"
                        data-wow-delay="400ms"
                      >
                        <div className="product-single-left-bottom-img">
                          <Link href="#">
                            <img src={Shopdtlsimg3.src} alt="product-2" />
                          </Link>
                        </div>
                      </div>
                      <div
                        className="col-4 wow fadeInLeft animated"
                        data-wow-duration="1500ms"
                        data-wow-delay="200ms"
                      >
                        <div className="product-single-left-bottom-img">
                          <Link href="#">
                            <img src={Shopdtlsimg1.src} alt="product-4" />
                          </Link>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
              <div className="col-lg-6 col-md-12 col-sm-12">
                <div
                  className="product-single-right wow fadeInRight animated"
                  data-wow-duration="1500ms"
                  data-wow-delay="00ms"
                >
                  <div className="product-rating-star">
                    <i className="fas fa-star" />
                    <i className="fas fa-star" />
                    <i className="fas fa-star" />
                    <i className="fas fa-star" />
                    <i className="fas fa-star" />
                  </div>
                  <div
                    className="product-name wow fadeInRight animated"
                    data-wow-duration="1500ms"
                    data-wow-delay="100ms"
                  >
                    <h2>Black Headphone</h2>
                  </div>
                  <div
                    className="product-price wow fadeInRight animated"
                    data-wow-duration="1500ms"
                    data-wow-delay="200ms"
                  >
                    <h5>$13.00</h5>
                  </div>
                  <div
                    className="product-details wow fadeInRight animated"
                    data-wow-duration="1500ms"
                    data-wow-delay="300ms"
                  >
                    <p>
                      Doloremque laudantium, totam rem aperiam, eaque ipsa quae
                      abillo inventore veritatis quasi architecto beatae vitae
                      dicta sunt explicabo Nemo enim ipsam voluptatem quia to
                      voluptas sit aspernatur aut odit autfugite
                    </p>
                  </div>
                  <form
                    className="cart wow fadeInRight animated"
                    data-wow-duration="1500ms"
                    data-wow-delay="400ms"
                  >
                    <div className="qty-container">
                      <button
                        className="qty-btn-minus btn-primary btn-rounded mr-1"
                        type="button"
                      >
                        <i className="fa fa-chevron-left" />
                      </button>
                      <input
                        type="text"
                        name="qty"
                        defaultValue={1}
                        className="input-qty input-rounded"
                      />
                      <button
                        className="qty-btn-plus btn-primary btn-rounded ml-1"
                        type="button"
                      >
                        <i className="fa fa-chevron-right" />
                      </button>
                    </div>
                    <Link href="/cart" className="thm-btn main-btn">
                      Add to Cart
                      <i className="icon-right-arrow" />
                    </Link>
                  </form>
                  <div
                    className="product-categories wow fadeInRight animated"
                    data-wow-duration="1500ms"
                    data-wow-delay="500ms"
                  >
                    <h4>Categories :</h4>
                    <ul>
                      <li>
                        <Link href="#">T-Shirt</Link>
                      </li>
                      <li>
                        <Link href="#">Bag</Link>
                      </li>
                      <li>
                        <Link href="#">Shoe</Link>
                      </li>
                    </ul>
                  </div>
                  <div
                    className="product-tag wow fadeInRight animated"
                    data-wow-duration="1500ms"
                    data-wow-delay="600ms"
                  >
                    <h4>Popular Tags</h4>
                    <ul className="product-tag-btn">
                      <li>
                        <Link
                          href="#"
                          className="wow fadeInRight animated"
                          data-wow-duration="1500ms"
                          data-wow-delay="700ms"
                        >
                          Shop
                        </Link>
                      </li>
                      <li>
                        <Link
                          href="#"
                          className="wow fadeInRight animated"
                          data-wow-duration="1500ms"
                          data-wow-delay="800ms"
                        >
                          Men
                        </Link>
                      </li>
                      <li>
                        <Link
                          href="#"
                          className="wow fadeInRight animated"
                          data-wow-duration="1500ms"
                          data-wow-delay="900ms"
                        >
                          Women
                        </Link>
                      </li>
                    </ul>
                  </div>
                </div>
              </div>
            </div>
            <div className="product-desc-reviews">
              <ul className="nav tabs product-desc-reviews-btn">
                <li
                  className="wow fadeInLeft animated"
                  data-wow-duration="1500ms"
                  data-wow-delay="300ms"
                >
                  <Link
                    className={showDesc ? "btn active" : "btn"}
                    id="description-tab"
                    data-bs-toggle="tab"
                    onClick={() => {
                      setshowAdditon(false);
                      setshowReview(false);
                      setshowDesc(true);
                    }}
                    href="#description"
                    aria-controls="description"
                  >
                    Descriptions
                    <i className="icon-right-arrow" />
                  </Link>
                </li>
                <li
                  className="wow fadeInLeft animated"
                  data-wow-duration="1500ms"
                  data-wow-delay="100ms"
                >
                  <Link
                    className={showReview ? "btn active" : "btn"}
                    id="reviews-tab"
                    data-bs-toggle="tab"
                    onClick={() => {
                      setshowAdditon(false);
                      setshowReview(true);
                      setshowDesc(false);
                    }}
                    href="#reviews"
                    aria-controls="reviews"
                    tabIndex={-1}
                  >
                    Reviews
                    <i className="icon-right-arrow" />
                  </Link>
                </li>
                <li
                  className="wow fadeInLeft animated"
                  data-wow-duration="1500ms"
                  data-wow-delay="100ms"
                >
                  <Link
                    className={showAdditon ? "btn active" : "btn"}
                    id="additional-tab"
                    data-bs-toggle="tab"
                    onClick={() => {
                      setshowAdditon(true);
                      setshowReview(false);
                      setshowDesc(false);
                    }}
                    href="#additional"
                    aria-controls="additional"
                    tabIndex={-1}
                  >
                    Additional Information's
                    <i className="icon-right-arrow" />
                  </Link>
                </li>
              </ul>
              <div className="tab-content">
                <div
                  className={
                    showDesc ? "tab-pane fade active show" : "tab-pane fade"
                  }
                  id="description"
                  role="tabpanel"
                  aria-labelledby="description-tab"
                >
                  <div className="product-desc-wrapper">
                    <div className="single-desc">
                      <p
                        className="desc-text1 wow fadeInUp animated"
                        data-wow-duration="1500ms"
                        data-wow-delay="100ms"
                      >
                        Must explain to you how all this mistaken idea of
                        denouncing pleasure and praising pain was born and I
                        will give you a complete account of the system, and
                        expound the actual teachings of the great explorer of
                        the truth, the master-builder of human happiness. No one
                        rejects, dislikes, or avoids pleasure itself, because it
                        is pleasure, but because those who do not know how to
                        pursue pleasure rationally encounter consequences that
                        are extremely painful. Nor again is there anyone who
                        loves or pursues or desires to obtain pain of itself,
                        because it is pain, but because occasionally
                      </p>
                      <h3
                        className="desc-title wow fadeInUp animated"
                        data-wow-duration="1500ms"
                        data-wow-delay="200ms"
                      >
                        Additional information
                      </h3>
                      <p
                        className="desc-text2 wow fadeInUp animated"
                        data-wow-duration="1500ms"
                        data-wow-delay="300ms"
                      >
                        Circumstances occur in which toil and pain can procure
                        him some great pleasure. To take a trivial example,
                        which of us ever undertakes laborious physical exercise,
                        except to obtain some advantage from it? But who has any
                        right to find fault with a man who chooses
                      </p>
                      <ul
                        className="product-desc-advantage wow fadeInUp animated"
                        data-wow-duration="1500ms"
                        data-wow-delay="400ms"
                      >
                        <li>
                          <i className="icon icon-check" />
                          Modern Headphone
                        </li>
                        <li>
                          <i className="icon icon-check" />
                          Black Color
                        </li>
                        <li>
                          <i className="icon icon-check" />
                          Height Quality Products
                        </li>
                      </ul>
                    </div>
                  </div>
                </div>
                <div
                  className={
                    showReview ? "tab-pane fade active show" : "tab-pane fade"
                  }
                  id="reviews"
                  role="tabpanel"
                  aria-labelledby="reviews-tab"
                >
                  <div className="reviews-wrapper">
                    <div className="row">
                      <div
                        className="col-lg-6 wow fadeInLeft animated"
                        data-wow-duration="1500ms"
                        data-wow-delay="200ms"
                      >
                        <div className="comment-area pro-desc-commnet-area">
                          <h3 className="title">Review for this product</h3>
                          <div className="comment-list">
                            <div className="comment">
                              <div className="comment-single">
                                <div className="comment-image">
                                  <img src={Blogimg1.src} alt="comment-1-1" />
                                </div>
                                <div className="comment-content">
                                  <div className="comment-title-inner">
                                    <h6>William L. Jackson</h6>
                                    <div className="product-rating-star">
                                      <i className="fas fa-star" />
                                      <i className="fas fa-star" />
                                      <i className="fas fa-star" />
                                      <i className="fas fa-star" />
                                      <i className="fas fa-star" />
                                    </div>
                                  </div>
                                  <p className="comment-text">
                                    Quis autem vel eum iure reprehenderit qui in
                                    ea voluptate velit esse molestiae
                                    consequatur qui dolorem eum fugiat voluptas
                                  </p>
                                  <div className="comment-reply-btn">
                                    <Link
                                      href="/blog-details"
                                      className="post-reply-inner"
                                    >
                                      Reply
                                      <i className="icon-right-arrow" />
                                    </Link>
                                  </div>
                                </div>
                              </div>
                              <div className="comment-single comment-single-two">
                                <div className="comment-image">
                                  <img src={Blogimg2.src} alt="comment-1-2" />
                                </div>
                                <div className="comment-content">
                                  <div className="comment-title-inner">
                                    <h6>James M. Stovall</h6>
                                    <div className="product-rating-star">
                                      <i className="fas fa-star" />
                                      <i className="fas fa-star" />
                                      <i className="fas fa-star" />
                                      <i className="fas fa-star" />
                                      <i className="fas fa-star" />
                                    </div>
                                  </div>
                                  <p className="comment-text">
                                    Quis autem vel eum iure reprehenderit qui in
                                    ea voluptate velit esse molestiae
                                    consequatur qui dolorem eum fugiat voluptas
                                  </p>
                                  <div className="comment-reply-btn">
                                    <Link
                                      href="/blog-details"
                                      className="post-reply-inner"
                                    >
                                      Reply
                                      <i className="icon-right-arrow" />
                                    </Link>
                                  </div>
                                </div>
                              </div>
                            </div>
                          </div>
                        </div>
                      </div>
                      <div
                        className="col-lg-6 wow fadeInRight animated"
                        data-wow-duration="1500ms"
                        data-wow-delay="200ms"
                      >
                        <div className="comment-respond pro-des-commend-respond">
                          <h3 className="title">Add a Review</h3>
                          <p>
                            Your email address will not be published. Required
                            fields are marked*
                          </p>
                          <div className="rating-wrapper">
                            <div className="reating-inner">
                              <Link href="#">
                                <i className="fas fa-star" />
                              </Link>
                              <Link href="#">
                                <i className="fas fa-star" />
                              </Link>
                              <Link href="#">
                                <i className="fas fa-star" />
                              </Link>
                              <Link href="#">
                                <i className="fas fa-star" />
                              </Link>
                              <Link href="#">
                                <i className="fas fa-star" />
                              </Link>
                            </div>
                          </div>
                          <div className="comment-respond-form">
                            <form action="#">
                              <div className="row">
                                <div className="col-lg-6 col-12">
                                  <div className="form-group">
                                    <input
                                      id="name"
                                      type="text"
                                      placeholder="Full Name"
                                      required=""
                                    />
                                  </div>
                                </div>
                                <div className="col-lg-6 col-12">
                                  <div className="form-group">
                                    <input
                                      type="email"
                                      name="EMAIL"
                                      placeholder="Email Address"
                                      required=""
                                    />
                                  </div>
                                </div>
                                <div className="col-12">
                                  <div className="form-group">
                                    <textarea
                                      name="message"
                                      placeholder="Message"
                                      required=""
                                      defaultValue={""}
                                    />
                                  </div>
                                </div>
                                <div className="col-lg-12">
                                  <div className="form-submit">
                                    <button
                                      type="submit"
                                      className="thm-btn main-btn"
                                    >
                                      Submit Comment
                                      <i className="icon-right-arrow" />
                                    </button>
                                  </div>
                                </div>
                              </div>
                            </form>
                          </div>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
                <div
                  className={
                    showAdditon ? "tab-pane fade active show" : "tab-pane fade"
                  }
                  id="additional"
                  role="tabpanel"
                  aria-labelledby="additional-tab"
                >
                  <div className="additional-wrapper">
                    <div className="product-desc-wrapper">
                      <div className="single-desc">
                        <h3
                          className="desc-title wow fadeInUp animated"
                          data-wow-duration="1500ms"
                          data-wow-delay="200ms"
                        >
                          Additional information
                        </h3>
                        <p
                          className="desc-text2 wow fadeInUp animated"
                          data-wow-duration="1500ms"
                          data-wow-delay="300ms"
                        >
                          Circumstances occur in which toil and pain can procure
                          him some great pleasure. To take a trivial example,
                          which of us ever undertakes laborious physical
                          exercise, except to obtain some advantage from it? But
                          who has any right to find fault with a man who chooses
                        </p>
                        <ul
                          className="product-desc-advantage wow fadeInUp animated"
                          data-wow-duration="1500ms"
                          data-wow-delay="400ms"
                        >
                          <li>
                            <i className="icon icon-check" />
                            Modern Headphone
                          </li>
                          <li>
                            <i className="icon icon-check" />
                            Black Color
                          </li>
                          <li>
                            <i className="icon icon-check" />
                            Height Quality Products
                          </li>
                        </ul>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
          <div className="related-products">
            <div
              className="section-main-title text-center wow fadeInUp animated"
              data-wow-duration="1500ms"
              data-wow-delay="100ms"
            >
              <h2 className="mx-auto">Related Products</h2>
            </div>
            <div className="row">
              <div
                className="col-lg-3 col-md-6 col-sm-6 col-12 wow fadeInRight animated animated"
                data-wow-duration="1500ms"
                data-wow-delay="100ms"
                style={{
                  visibility: "visible",
                  animationDuration: "1500ms",
                  animationDelay: "100ms",
                  animationName: "fadeInRight",
                }}
              >
                <div className="product-box">
                  <div className="product-img">
                    <img src={Shopdtlsimg4.src} alt="product-1" />
                    <div className="product-inner-box">
                      <div className="product-add-btn">
                        <Link href="/cart" className="thm-btn main-btn">
                          Add to Cart
                          <i className="icon-right-arrow" />
                        </Link>
                      </div>
                    </div>
                  </div>
                  <div className="product-rating-star">
                    <i className="fas fa-star" />
                    <i className="fas fa-star" />
                    <i className="fas fa-star" />
                    <i className="fas fa-star" />
                    <i className="fas fa-star" />
                  </div>
                  <div className="product-title">
                    <h5>
                      <Link href="/shop-details">Women Leather Bag</Link>
                    </h5>
                  </div>
                  <div className="product-price">
                    <h6>$13.00</h6>
                  </div>
                </div>
              </div>
              <div
                className="col-lg-3 col-md-6 col-sm-6 col-12 wow fadeInRight animated animated"
                data-wow-duration="1500ms"
                data-wow-delay="300ms"
                style={{
                  visibility: "visible",
                  animationDuration: "1500ms",
                  animationDelay: "300ms",
                  animationName: "fadeInRight",
                }}
              >
                <div className="product-box">
                  <div className="product-img">
                    <img src={Shopdtlsimg5.src} alt="product-2" />
                    <div className="product-inner-box">
                      <div className="product-add-btn">
                        <Link href="/cart" className="thm-btn main-btn">
                          Add to Cart
                          <i className="icon-right-arrow" />
                        </Link>
                      </div>
                    </div>
                  </div>
                  <div className="product-rating-star">
                    <i className="fas fa-star" />
                    <i className="fas fa-star" />
                    <i className="fas fa-star" />
                    <i className="fas fa-star" />
                    <i className="fas fa-star" />
                  </div>
                  <div className="product-title">
                    <h5>
                      <Link href="/shop-details">Women Leather Bag</Link>
                    </h5>
                  </div>
                  <div className="product-price">
                    <h6>$13.00</h6>
                  </div>
                </div>
              </div>
              <div
                className="col-lg-3 col-md-6 col-sm-6 col-12 wow fadeInRight animated animated"
                data-wow-duration="1500ms"
                data-wow-delay="500ms"
                style={{
                  visibility: "visible",
                  animationDuration: "1500ms",
                  animationDelay: "500ms",
                  animationName: "fadeInRight",
                }}
              >
                <div className="product-box">
                  <div className="product-img">
                    <img src={Shopdtlsimg6.src} alt="product-3" />
                    <div className="product-inner-box">
                      <div className="product-add-btn">
                        <Link href="/cart" className="thm-btn main-btn">
                          Add to Cart
                          <i className="icon-right-arrow" />
                        </Link>
                      </div>
                    </div>
                  </div>
                  <div className="product-rating-star">
                    <i className="fas fa-star" />
                    <i className="fas fa-star" />
                    <i className="fas fa-star" />
                    <i className="fas fa-star" />
                    <i className="fas fa-star" />
                  </div>
                  <div className="product-title">
                    <h5>
                      <Link href="/shop-details">Women Leather Bag</Link>
                    </h5>
                  </div>
                  <div className="product-price">
                    <h6>$13.00</h6>
                  </div>
                </div>
              </div>
              <div
                className="col-lg-3 col-md-6 col-sm-6 col-12 wow fadeInRight animated animated"
                data-wow-duration="1500ms"
                data-wow-delay="100ms"
                style={{
                  visibility: "visible",
                  animationDuration: "1500ms",
                  animationDelay: "100ms",
                  animationName: "fadeInRight",
                }}
              >
                <div className="product-box">
                  <div className="product-img">
                    <img src={Shopdtlsimg7.src} alt="product-4" />
                    <div className="product-inner-box">
                      <div className="product-add-btn">
                        <Link href="/cart" className="thm-btn main-btn">
                          Add to Cart
                          <i className="icon-right-arrow" />
                        </Link>
                      </div>
                    </div>
                  </div>
                  <div className="product-rating-star">
                    <i className="fas fa-star" />
                    <i className="fas fa-star" />
                    <i className="fas fa-star" />
                    <i className="fas fa-star" />
                    <i className="fas fa-star" />
                  </div>
                  <div className="product-title">
                    <h5>
                      <Link href="/shop-details">Men Leather Shoe</Link>
                    </h5>
                  </div>
                  <div className="product-price">
                    <h6>$13.00</h6>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </section>
    </div>
  );
}

export default ShopDetails;
