"use client";
import Link from "next/link";
import "swiper/css";
import { Swiper, SwiperSlide } from "swiper/react";
import Cta1 from "../../../public/assets/images/shapes/cta-five-shape-1.png";
import Cta2 from "../../../public/assets/images/shapes/cta-five-shape-2.png";
import Test1 from "../../../public/assets/images/testimonial/testimonial-four-detail-img-one.jpg";
import Test2 from "../../../public/assets/images/testimonial/testimonial-four-detail-img-two.jpg";
import Tab1 from "../../../public/assets/images/testimonial/testimonial-three-tab-img-1.png";
import Tab2 from "../../../public/assets/images/testimonial/testimonial-three-tab-img-2.png";
import Tab3 from "../../../public/assets/images/testimonial/testimonial-three-tab-img-3.png";

const TeamTest = {
  autoplay: {
    delay: 1000,
  },
  responsive: [
    {
      breakpoint: 1024,
      settings: {
        slidesPerView: 2,
        slidestoscroll: 3,
        arrows: true,
      },
    },
    {
      breakpoint: 992,
      settings: {
        slidesPerView: 2,
        slidestoscroll: 3,
        arrows: false,
      },
    },
    {
      breakpoint: 740,
      settings: {
        slidesPerView: 1,
        slidestoscroll: 3,
        arrows: false,
      },
    },
    {
      breakpoint: 480,
      settings: {
        slidesPerView: 1,
        slidestoscroll: 3,
        arrows: false,
      },
    },
  ],
};

function TeamMemberContent() {
  return (
    <div>
      <div className="team-member-content">
        <section className="cta-five">
          <div className="container-fluid">
            <div
              className="cta-four-shape-1 wow fadeInLeft animated"
              data-wow-duration="1500ms"
              data-wow-delay="100ms"
            >
              <div className="animation_image_zoom">
                <div className="cta-four-shape-1-img">
                  <img src={Cta1.src} alt="cta-five-shape-1" />
                </div>
              </div>
            </div>
            <div
              className="cta-four-shape-2 wow fadeInRight animated"
              data-wow-duration="1500ms"
              data-wow-delay="100ms"
            >
              <div className="animation_image_zoom">
                <div className="cta-four-shape-2-img">
                  <img src={Cta2.src} alt="cta-five-shape-2" />
                </div>
              </div>
            </div>
            <div className="container">
              <div className="cta-four-detail-box cta-five-detail-box">
                <div
                  className="cta-four-detail-box-shape-1 wow fadeInLeft animated"
                  data-wow-duration="1500ms"
                  data-wow-delay="300ms"
                >
                  <div className="animation_image_zoom">
                    <div className="cta-four-detail-box-shape-1-img">
                      <img
                        src={Test1.src}
                        alt="testimonial-four-detail-img-one"
                      />
                    </div>
                  </div>
                </div>
                <div
                  className="cta-four-detail-box-shape-2 wow fadeInRight animated"
                  data-wow-duration="1500ms"
                  data-wow-delay="300ms"
                >
                  <div className="animation_image_zoom">
                    <div className="cta-four-detail-box-shape-1-img">
                      <img
                        src={Test2.src}
                        alt="testimonial-four-detail-img-two"
                      />
                    </div>
                  </div>
                </div>
                <div className="cta-four-detail-box-shape-3" />
                <div className="cta-four-detail-box-shape-4" />
                <div className="section-five-title">
                  <div
                    className="section-five-title-title text-center wow fadeInUp animated"
                    data-wow-duration="1500ms"
                    data-wow-delay="100ms"
                  >
                    <h2>
                      Ready to Boost your <br /> Digital product marketing ?
                    </h2>
                  </div>
                  <div
                    className="section-five-details text-center wow fadeInUp animated"
                    data-wow-duration="1500ms"
                    data-wow-delay="300ms"
                  >
                    <p>Approach focuses on capturing the essential</p>
                  </div>
                </div>
                <div
                  className="cta-four-btn text-center wow fadeInUp animated"
                  data-wow-duration="1500ms"
                  data-wow-delay="500ms"
                >
                  <Link href="/contact" className="main-black-btn thm-btn">
                    Get Started
                    <i className="icon-right-arrow" />
                  </Link>
                </div>
              </div>
            </div>
          </div>
        </section>
        <section className="testimonial-six testimonial-seven">
          <div className="testimonial-six-shape-1" />
          <div className="testimonial-six-shape-2" />
          <div className="container">
            <div className="testimonial-six-title-box">
              <div className="section-three-title">
                <div className="section-three-title-title text-center">
                  <h2>1253+ Customer Say About Us</h2>
                </div>
              </div>
              <div className="section-three-details text-center">
                <p>
                  Digital marketing &amp; advertising approach focuses on
                  capturing the essential
                </p>
              </div>
            </div>
            <Swiper
              className="swiper-wrapper"
              {...TeamTest}
              slidesPerView={3}
              slidestoscroll={1}
              spaceBetween={30}
            >
              <SwiperSlide
                className="testimonial-six-single-box testimonial-six-single-box-one wow fadeInUp animated"
                data-wow-duration="1500ms"
                data-wow-delay="100ms"
              >
                <div className="testimonial-six-single-title-box">
                  <div className="testimonial-six-single-title-img">
                    <img src={Tab1.src} alt="testimonial-three-tab-img-1" />
                  </div>
                  <div className="testimonial-six-single-title">
                    <h4>
                      Russell J. <span>/ CEO &amp; Founder</span>
                    </h4>
                  </div>
                </div>
                <div className="testimonial-six-single-detail">
                  <p>
                    " On the other hand denounce with righteou indignation and
                    dislike men beguiled and demoralized "
                  </p>
                </div>
                <div className="star-icon">
                  <i className="fas fa-star" />
                  <i className="fas fa-star" />
                  <i className="fas fa-star" />
                  <i className="fas fa-star" />
                  <i className="fas fa-star" />
                </div>
              </SwiperSlide>
              <SwiperSlide
                className="testimonial-six-single-box testimonial-six-single-box-two wow fadeInUp animated"
                data-wow-duration="1500ms"
                data-wow-delay="300ms"
              >
                <div className="testimonial-six-single-title-box">
                  <div className="testimonial-six-single-title-img">
                    <img src={Tab3.src} alt="testimonial-three-tab-img-3" />
                  </div>
                  <div className="testimonial-six-single-title">
                    <h4>
                      Somalia <span>/ Developer</span>
                    </h4>
                  </div>
                </div>
                <div className="testimonial-six-single-detail">
                  <p>
                    {" "}
                    On the other hand denounce with righteou indignation and
                    dislike men beguiled and demoralized "
                  </p>
                </div>
                <div className="star-icon">
                  <i className="fas fa-star" />
                  <i className="fas fa-star" />
                  <i className="fas fa-star" />
                  <i className="fas fa-star" />
                  <i className="fas fa-star" />
                </div>
              </SwiperSlide>
              <SwiperSlide
                className="testimonial-six-single-box testimonial-six-single-box-three wow fadeInUp animated"
                data-wow-duration="1500ms"
                data-wow-delay="500ms"
              >
                <div className="testimonial-six-single-title-box">
                  <div className="testimonial-six-single-title-img">
                    <img src={Tab2.src} alt="testimonial-three-tab-img-2" />
                  </div>
                  <div className="testimonial-six-single-title">
                    <h4>
                      Michel H. <span>/ Businessman</span>
                    </h4>
                  </div>
                </div>
                <div className="testimonial-six-single-detail">
                  <p>
                    " On the other hand denounce with righteou indignation and
                    dislike men beguiled and demoralized "
                  </p>
                </div>
                <div className="star-icon">
                  <i className="fas fa-star" />
                  <i className="fas fa-star" />
                  <i className="fas fa-star" />
                  <i className="fas fa-star" />
                  <i className="fas fa-star" />
                </div>
              </SwiperSlide>
              <SwiperSlide
                className="testimonial-six-single-box testimonial-six-single-box-one wow fadeInUp animated"
                data-wow-duration="1500ms"
                data-wow-delay="100ms"
              >
                <div className="testimonial-six-single-title-box">
                  <div className="testimonial-six-single-title-img">
                    <img src={Tab2.src} alt="testimonial-three-tab-img-1" />
                  </div>
                  <div className="testimonial-six-single-title">
                    <h4>
                      Russell J. <span>/ CEO &amp; Founder</span>
                    </h4>
                  </div>
                </div>
                <div className="testimonial-six-single-detail">
                  <p>
                    " On the other hand denounce with righteou indignation and
                    dislike men beguiled and demoralized "
                  </p>
                </div>
                <div className="star-icon">
                  <i className="fas fa-star" />
                  <i className="fas fa-star" />
                  <i className="fas fa-star" />
                  <i className="fas fa-star" />
                  <i className="fas fa-star" />
                </div>
              </SwiperSlide>
              <SwiperSlide
                className="testimonial-six-single-box testimonial-six-single-box-two wow fadeInUp animated"
                data-wow-duration="1500ms"
                data-wow-delay="300ms"
              >
                <div className="testimonial-six-single-title-box">
                  <div className="testimonial-six-single-title-img">
                    <img src={Tab3.src} alt="testimonial-three-tab-img-3" />
                  </div>
                  <div className="testimonial-six-single-title">
                    <h4>
                      Somalia <span>/ Developer</span>
                    </h4>
                  </div>
                </div>
                <div className="testimonial-six-single-detail">
                  <p>
                    {" "}
                    On the other hand denounce with righteou indignation and
                    dislike men beguiled and demoralized "
                  </p>
                </div>
                <div className="star-icon">
                  <i className="fas fa-star" />
                  <i className="fas fa-star" />
                  <i className="fas fa-star" />
                  <i className="fas fa-star" />
                  <i className="fas fa-star" />
                </div>
              </SwiperSlide>
              <SwiperSlide
                className="testimonial-six-single-box testimonial-six-single-box-three wow fadeInUp animated"
                data-wow-duration="1500ms"
                data-wow-delay="500ms"
              >
                <div className="testimonial-six-single-title-box">
                  <div className="testimonial-six-single-title-img">
                    <img src={Tab2.src} alt="testimonial-three-tab-img-2" />
                  </div>
                  <div className="testimonial-six-single-title">
                    <h4>
                      Michel H. <span>/ Businessman</span>
                    </h4>
                  </div>
                </div>
                <div className="testimonial-six-single-detail">
                  <p>
                    " On the other hand denounce with righteou indignation and
                    dislike men beguiled and demoralized "
                  </p>
                </div>
                <div className="star-icon">
                  <i className="fas fa-star" />
                  <i className="fas fa-star" />
                  <i className="fas fa-star" />
                  <i className="fas fa-star" />
                  <i className="fas fa-star" />
                </div>
              </SwiperSlide>
            </Swiper>
          </div>
        </section>
      </div>
    </div>
  );
}

export default TeamMemberContent;
