import localFont from "next/font/local";
import "./globals.css";
import "../public../../../public/assets/vendors/bootstrap/css/bootstrap.css";
import "../public../../../public/assets/vendors/fontawesome/css/all.min.css";
import "../public../../../public/assets/vendors/animate/animate.min.css";
import "../public../../../public/assets/vendors/youtube-popup/youtube-popup.css";
import "../public../../../public/assets/vendors/icomoon/style.css";
import "../public../../../public/assets/css/style.css";
import "../public../../../public/assets/css/responsive.css";

import FooterOne from "./component/FooterOne/Main";
import HeaderOne from "./component/HeaderOne/Main";

const geistSans = localFont({
  src: "./fonts/GeistVF.woff",
  variable: "--font-geist-sans",
  weight: "100 900",
});
const geistMono = localFont({
  src: "./fonts/GeistMonoVF.woff",
  variable: "--font-geist-mono",
  weight: "100 900",
});

export const metadata = {
  title: "Knotblaze",
  description: "knotblaze.com",
};

export default function RootLayout({ children }) {
  return (
    <html lang="en">
      <body className={`${geistSans.variable} ${geistMono.variable}`}>
        <HeaderOne />
        {children}
        <FooterOne />
      </body>
    </html>
  );
}
