<?php include ("layout/header.php") ?>
<!-- HERO BANNER ONE -->
<section class="rts-hero rts-hero__one banner-style-home-one">
    <div class="container">
        <div class="rts-hero__blur-area"></div>
        <div class="row align-items-end position-relative">
            <div class="col-lg-6">
                <div class="rts-hero__content w-550">
                    <h6 data-sal="slide-down" data-sal-delay="300" data-sal-duration="800">
                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none">
                            <path
                                d="M23.9799 11.9805C23.9799 10.3545 23.2659 8.8205 22.0549 7.8565C22.1949 6.2345 21.6149 4.6455 20.4649 3.4945C19.3149 2.3455 17.7299 1.7635 16.1879 1.9395C14.1739 -0.616499 9.82288 -0.664499 7.85588 1.9045C4.62288 1.5205 1.51388 4.5645 1.93988 7.7725C-0.616121 9.7865 -0.665121 14.1375 1.90488 16.1055C1.76488 17.7275 2.34488 19.3165 3.49488 20.4675C4.64488 21.6165 6.23188 22.1985 7.77188 22.0225C9.78588 24.5785 14.1369 24.6265 16.1039 22.0575C17.7239 22.1965 19.3139 21.6185 20.4649 20.4675C21.6139 19.3175 22.1939 17.7275 22.0199 16.1905C23.2659 15.1425 23.9799 13.6085 23.9799 11.9825V11.9805ZM7.97988 8.9805C7.98588 7.6725 9.97388 7.6725 9.97988 8.9805C9.97388 10.2885 7.98588 10.2885 7.97988 8.9805ZM10.8119 15.5355C10.5039 15.9985 9.87888 16.1165 9.42488 15.8125C8.96488 15.5065 8.84088 14.8855 9.14788 14.4255L13.1479 8.4255C13.4539 7.9665 14.0739 7.8405 14.5349 8.1485C14.9949 8.4545 15.1189 9.0755 14.8119 9.5355L10.8119 15.5355ZM14.9799 15.9805C13.6719 15.9745 13.6719 13.9865 14.9799 13.9805C16.2879 13.9865 16.2879 15.9745 14.9799 15.9805Z"
                                fill="#FFC107" />
                        </svg>
                        20% Discount on Your First Month Purchase
                    </h6>
                    <h1 class="heading" data-sal="slide-down" data-sal-delay="300" data-sal-duration="800">All-In-One
                        Website Solution
                    </h1>
                    <p class="description" data-sal="slide-down" data-sal-delay="400" data-sal-duration="800">Access a
                        Free Website Builder on selected Hosting Packages. Kickstart Your Online Presence Now!</p>
                    <div class="rts-hero__content--group" data-sal="slide-down" data-sal-delay="500"
                        data-sal-duration="800">
                        <a href="webhost.php" class="primary__btn white__bg">Get Started <i
                                class="fa-regular fa-long-arrow-right"></i></a>
                        <a href="webhost.php#webhostingpricingplan" class="btn__zero plan__btn">Plans & Pricing <i
                                class="fa-regular fa-long-arrow-right"></i></a>
                    </div>
                    <p data-sal="slide-down" data-sal-delay="600" data-sal-duration="800"><img
                            src="assets/images/icon/dollar.svg" alt="">Starting from <span class="price"
                            data-initial-price="4.40">USD 4.40</span> per month</p>
                </div>
            </div>
            <div class="col-lg-6">
                <div class="rts-hero__images position-relative">
                    <div class="rts-hero-main">
                        <div class="image-main ">
                            <img class="main top-bottom2" src="assets/images/banner/hosting-01.svg" alt="">
                        </div>
                        <img class="hero-shape one" src="assets/images/banner/hosting.svg" alt="">
                    </div>
                    <div class="rts-hero__images--shape">
                        <div class="one top-bottom">
                            <img src="assets/images/banner/left.svg" alt="">
                        </div>
                        <div class="two bottom-top">
                            <img src="assets/images/banner/left.svg" alt="">
                        </div>
                        <div class="three top-bottom">
                            <img src="assets/images/banner/top.svg" alt="">
                        </div>
                        <div class="four bottom-top">
                            <img src="assets/images/banner/right.svg" alt="">
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<!-- HERO BANNER ONE END -->


<!-- SEARCH DOMAIN -->
<!-- <div class="rts-domain-finder section__padding">
    <div class="container">
        <div class="row">
            <div class="col-12">
                <div class="rts-domain-finder__content domain-finder-bg">
                    <h3 data-sal="slide-down" data-sal-delay="300" data-sal-duration="800">Find Your Perfect Domain
                    </h3>
                    <form action="https://www.knothost.com/billing/cart.php?a=add&domain=register" method="POST"
                        class="domain-checker" data-sal="slide-down" data-sal-delay="400" data-sal-duration="800">
                        <input type="text" id="domain-name" name="query" size="20"
                            placeholder="Register a domain name to start" required>
                        <input type="hidden" name="domain" value="register">
                        <input type="hidden" name="a" value="add">
                        <button type="submit" name="domain_type">search domain</button>
                    </form>
                    <div class="compare">
                        <div class="compare__list">
                            <ul>
                                <li data-sal="slide-down" data-sal-delay="500" data-sal-duration="800">Compare:</li>
                                <li data-sal="slide-down" data-sal-delay="600" data-sal-duration="800"><span
                                        class="ext">.com</span> only $6.19</li>
                                <li data-sal="slide-down" data-sal-delay="700" data-sal-duration="800"><span
                                        class="ext">.net</span> only $6.19</li>
                                <li data-sal="slide-down" data-sal-delay="800" data-sal-duration="800"><span
                                        class="ext">.info</span> only $6.19</li>
                                <li data-sal="slide-down" data-sal-delay="900" data-sal-duration="800"><span
                                        class="ext">.org</span> only $6.19</li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div> -->
<!-- SEARCH DOMAIN END -->



<!-- FLASH SELL AREA -->
<section class="rts-flash-sell">
    <div class="container">
        <div class="rts-flash-sell__bg">
            <div class="row align-items-center">
                <div class="col-lg-4">
                    <div class="rts-flash-sell__title">
                        <h3 data-sal="slide-down" data-sal-delay="300" data-sal-duration="800">Hosting Flash Sale
                        </h3>
                        <p data-sal="slide-down" data-sal-delay="400" data-sal-duration="800">For a limited time,
                            launch your website
                            with incredible savings.
                        </p>
                        <a data-sal="slide-down" data-sal-delay="500" data-sal-duration="800" href="#"
                            class="primary__btn white__bg">See Details</a>
                    </div>
                </div>
                <div class="col-lg-8 p--0">
                    <div class="row">
                        <div class="col-lg-6 col-md-6">
                            <div class="single__sell">
                                <div class="single__sell--content">
                                    <div class="offer">for a limited Time</div>
                                    <div class="discount">20% Off</div>
                                    <span>on web hosting</span>
                                </div>
                                <div class="single__sell--image">
                                    <img src="assets/images/icon/cloud.svg" alt="">
                                </div>

                            </div>
                        </div>
                        <div class="col-lg-6 col-md-6">
                            <div class="single__sell">
                                <div class="single__sell--content">
                                    <div class="offer">for a limited Time</div>
                                    <div class="discount">10% Off</div>
                                    <span>on email hosting</span>
                                </div>
                                <div class="single__sell--image">
                                    <img src="assets/images/icon/domain.svg" alt="">
                                </div>

                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<!-- FLASH SELL AREA END -->

<!-- PRICING PLAN START -->
<div class="rts-pricing-plan card-plan-bg page-bg section__padding" id="webhostingpricingplan">
    <div class="container">
        <div class="row justify-content-center">
            <div class="rts-section text-center">
                <h2 class="rts-section__title" data-sal="slide-down" data-sal-delay="300" data-sal-duration="800">
                    Dubai's Trusted Web Hosting Provider</h2>
                <p class="rts-section__description" data-sal="slide-down" data-sal-delay="400" data-sal-duration="800">
                    Established in Dubai, we're your one-stop shop for reliable web hosting. Power your website with
                    speed, security, and exceptional performance. Choose the perfect plan to fit your needs and get
                    started building your online presence today! </p>
            </div>
        </div>
        <div class="row">
            <div class="row justify-content-center" data-sal="slide-down" data-sal-delay="400" data-sal-duration="800">
                <div class="col-lg-4 col-md-5">
                    <div class="rts-pricing-plan__tab plan__tab">
                        <div class="tab__button">
                            <div class="tab__button__item">
                                <button class="tab__price active" data-tab="monthly">monthly</button>
                                <button class="tab__price" data-tab="yearly">yearly</button>
                            </div>
                        </div>
                        <div class="discount">
                            <span class="line"><img src="assets/images/pricing/offer__vactor.svg" height="20" width="85"
                                    alt=""></span>
                            <p>20% save</p>
                        </div>
                    </div>
                </div>
            </div>
            <!-- PRICING PLAN -->
            <div class="price__content open" id="monthly" style="">
                <div class="row g-30 monthly">


                    <?php foreach ($pricingPlans as $index => $plan): ?>
                    <!-- single card -->
                    <div class="col-lg-3 col-md-6 col-sm-6">
                        <div class="card-plan <?php echo $plan['featured'] ? 'active' : ''; ?>">
                            <?php if ($plan['featured']): ?>
                            <div class="popular-tag">most popular</div>
                            <?php endif; ?>
                            <div class="card-plan__package">
                                <div class="icon">
                                    <img src="<?php echo $plan['icon']; ?>" height="30" width="30" alt="">
                                </div>
                                <h4 class="package__name"><?php echo $plan['name']; ?></h4>
                            </div>
                            <p class="card-plan__desc"><?php echo $plan['description']; ?></p>
                            <div class="card-plan__offer">
                                <span class="past-price"><span class="price"
                                        data-initial-price="<?php echo $plan['monthly_price']; ?>">$<?php echo $plan['monthly_price']; ?></span></span>
                                <span class="offer-given">Save <?php echo $plan['discount']; ?>%</span>
                            </div>
                            <h5 class="card-plan__price">
                                <span class="price"
                                    data-initial-price="<?php echo $plan['monthly_price'] * (1 - $plan['discount'] / 100); ?>">$<?php echo $plan['monthly_price']; ?></span>
                                <sub>/ month</sub>
                            </h5>
                            <div class="card-plan__cartbtn">
                                <a href="<?php echo $plan['link']; ?>">Buy Now</a>
                            </div>
                            <p class="card-plan__renew-price">
                                <span class="price"
                                    data-initial-price="<?php echo $plan['renewPrice']; ?>">$<?php echo $plan['renewPrice']; ?></span>/mo
                                when you renew
                            </p>
                            <div class="card-plan__feature">
                                <ul class="card-plan__feature--list">
                                    <?php
                                        $count = 0;
                                        foreach ($plan['features'] as $featureName => $featureValue):
                                            if ($count < 9):
                                                ?>
                                    <li class="card-plan__feature--list-item">
                                        <span class="text"><i
                                                class="fa-regular <?php echo $featureValue['show_check'] ? 'fa-check' : 'fa-xmark'; ?>"></i>
                                            <?php echo $featureName; ?> <?php echo $featureValue['value']; ?></span>
                                        <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom"
                                            data-bs-original-title="...">
                                            <i class="fa-light fa-circle-question"></i>
                                        </span>
                                    </li>
                                    <?php
                                                $count++;
                                            endif;
                                        endforeach;
                                        ?>
                                    <?php if ($count === 9): ?>
                                    <li class="card-plan__feature--list-trigered">
                                        <span class="text">More Features <i
                                                class="fa-sharp fa-regular fa-chevron-down"></i></span>
                                    </li>
                                    <?php endif; ?>
                                </ul>
                                <ul class="card-plan__feature--list more__feature">
                                    <?php
                                        $featureCount = 0;
                                        foreach ($plan['features'] as $featureName => $featureValue):
                                            $featureCount++;
                                            if ($featureCount > 9):
                                                ?>
                                    <li class="card-plan__feature--list-item">
                                        <span class="text"><i
                                                class="fa-regular <?php echo $featureValue['show_check'] ? 'fa-check' : 'fa-xmark'; ?>"></i>
                                            <?php echo $featureName; ?> <?php echo $featureValue['value']; ?></span>
                                        <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom"
                                            data-bs-original-title="...">
                                            <i class="fa-light fa-circle-question"></i>
                                        </span>
                                    </li>
                                    <?php
                                            endif;
                                            $count++;
                                        endforeach;
                                        ?>
                                    <?php if ($count > 9): ?>
                                    <li class="card-plan__feature--list-trigered">
                                        <span class="text">See less Features <i
                                                class="fa-sharp fa-regular fa-chevron-up"></i></span>
                                    </li>
                                    <?php endif; ?>
                                </ul>
                            </div>
                        </div>
                    </div>
                    <!-- single card end -->
                    <?php endforeach; ?>

                </div>
            </div>

            <!-- PRICING PLAN -->
            <div class="price__content" id="yearly" style="display: none;">
                <div class="row g-30 yearly">
                    <?php foreach ($pricingPlans as $index => $plan): ?>
                    <!-- single card -->
                    <div class="col-lg-3 col-md-6 col-sm-6">
                        <div class="card-plan <?php echo $plan['featured'] ? 'active' : ''; ?>">
                            <?php if ($plan['featured']): ?>
                            <div class="popular-tag">most popular</div>
                            <?php endif; ?>
                            <div class="card-plan__package">
                                <div class="icon">
                                    <img src="<?php echo $plan['icon']; ?>" height="30" width="30" alt="">
                                </div>
                                <h4 class="package__name"><?php echo $plan['name']; ?></h4>
                            </div>
                            <p class="card-plan__desc"><?php echo $plan['description']; ?></p>
                            <div class="card-plan__offer">
                                <span class="past-price"><span class="price"
                                        data-initial-price="<?php echo $plan['yearly_price']; ?>">$<?php echo $plan['yearly_price']; ?></span></span>
                                <span class="offer-given">Save <?php echo $plan['discount']; ?>%</span>
                            </div>
                            <h5 class="card-plan__price">
                                <span class="price"
                                    data-initial-price="<?php echo $plan['yearly_price'] * (1 - $plan['discount'] / 100); ?>">$<?php echo $plan['yearly_price']; ?></span>
                                <sub>/ year</sub>
                            </h5>
                            <div class="card-plan__cartbtn">
                                <a href="<?php echo $plan['link']; ?>">Buy Now</a>
                            </div>
                            <p class="card-plan__renew-price">
                                <span class="price"
                                    data-initial-price="<?php echo $plan['yearly_price']; ?>">$<?php echo $plan['yearly_price']; ?></span>/yr
                                when you renew
                            </p>
                            <div class="card-plan__feature">
                                <ul class="card-plan__feature--list">
                                    <?php
                                        $count = 0;
                                        foreach ($plan['features'] as $featureName => $featureValue):
                                            if ($count < 9):
                                                ?>
                                    <li class="card-plan__feature--list-item">
                                        <span class="text"><i
                                                class="fa-regular <?php echo $featureValue['show_check'] ? 'fa-check' : 'fa-xmark'; ?>"></i>
                                            <?php echo $featureName; ?> <?php echo $featureValue['value']; ?></span>
                                        <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom"
                                            data-bs-original-title="...">
                                            <i class="fa-light fa-circle-question"></i>
                                        </span>
                                    </li>
                                    <?php
                                                $count++;
                                            endif;
                                        endforeach;
                                        ?>
                                    <?php if ($count === 9): ?>
                                    <li class="card-plan__feature--list-trigered">
                                        <span class="text">More Features <i
                                                class="fa-sharp fa-regular fa-chevron-down"></i></span>
                                    </li>
                                    <?php endif; ?>
                                </ul>
                                <ul class="card-plan__feature--list more__feature">
                                    <?php
                                        $featureCount = 0;
                                        foreach ($plan['features'] as $featureName => $featureValue):
                                            $featureCount++;
                                            if ($featureCount > 9):
                                                ?>
                                    <li class="card-plan__feature--list-item">
                                        <span class="text"><i
                                                class="fa-regular <?php echo $featureValue['show_check'] ? 'fa-check' : 'fa-xmark'; ?>"></i>
                                            <?php echo $featureName; ?> <?php echo $featureValue['value']; ?></span>
                                        <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom"
                                            data-bs-original-title="...">
                                            <i class="fa-light fa-circle-question"></i>
                                        </span>
                                    </li>
                                    <?php
                                            endif;
                                            $count++;
                                        endforeach;
                                        ?>
                                    <?php if ($count > 9): ?>
                                    <li class="card-plan__feature--list-trigered">
                                        <span class="text">See less Features <i
                                                class="fa-sharp fa-regular fa-chevron-up"></i></span>
                                    </li>
                                    <?php endif; ?>
                                </ul>
                            </div>
                        </div>
                    </div>
                    <!-- single card end -->
                    <?php endforeach; ?>
                </div>
            </div>
        </div>
        <!-- <div class="view-plan-btn">
            <a href="pricing.php" class="btn long-btn">Customized Solutions</a>
        </div> -->
    </div>
</div>
<!-- PRICING PLAN START END -->






<!-- SEARCH DOMAIN -->
<div class="rts-domain-finder">
    <div class="container">
        <div class="row">
            <div class="col-12">
                <div class="rts-domain-finder__content domain-finder-bg">
                    <h3 data-sal="slide-down" data-sal-delay="300" data-sal-duration="800">Find Your Perfect
                        Domain
                    </h3>
                    <form action="https://www.knothost.com/billing/cart.php?a=add&domain=register" method="POST"
                        class="domain-checker" data-sal="slide-down" data-sal-delay="400" data-sal-duration="800">
                        <input type="text" id="domain-name" name="query" size="20"
                            placeholder="Register a domain name to start" required>
                        <input type="hidden" name="domain" value="register">
                        <input type="hidden" name="a" value="add">
                        <button type="submit" name="domain_type">search domain</button>
                    </form>
                    <div class="compare">
                        <div class="compare__list">
                            <ul>
                                <li data-sal="slide-down" data-sal-delay="500" data-sal-duration="800">Compare:
                                </li>
                                <li data-sal="slide-down" data-sal-delay="600" data-sal-duration="800"><span
                                        class="ext">.com</span> only <div class="price" data-initial-price="15.99">
                                        $15.99</div>
                                </li>
                                <li data-sal="slide-down" data-sal-delay="700" data-sal-duration="800"><span
                                        class="ext">.net</span> only <div class="price" data-initial-price="18.16">
                                        $18.16
                                    </div>
                                </li>
                                <li data-sal="slide-down" data-sal-delay="800" data-sal-duration="800"><span
                                        class="ext">.me</span> only <div class="price" data-initial-price="21.06">$21.06
                                    </div>
                                </li>
                                <li data-sal="slide-down" data-sal-delay="900" data-sal-duration="800"><span
                                        class="ext">.ae</span> only <div class="price" data-initial-price="49.99">$49.99
                                    </div>
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- SEARCH DOMAIN END -->

<!-- ABOUT US -->
<div class="rts-about position-relative">
    <div class="container">
        <div class="row">
            <div class="col-xl-6 col-lg-6">
                <div class="rts-about__image">
                    <img src="assets/images/about/about-big.png" alt="">
                    <img src="assets/images/about/about-shape-01.svg" alt="" class="shape one right-left">
                    <img src="assets/images/about/about-shape-02.svg" alt="" class="shape two">
                </div>
            </div>
            <div class="col-xl-5 col-lg-6">
                <div class="rts-about__content">
                    <h3 data-sal="slide-down" data-sal-delay="300" data-sal-duration="800">Knot Host Helps You
                        Succeed

                    </h3>
                    <p class="description" data-sal="slide-down" data-sal-delay="400" data-sal-duration="800">
                        WHY CHOOSE KNOT HOST AS YOUR HOSTING PROVIDER?
                    </p>
                    <div class="rts-about__content--single" data-sal="slide-down" data-sal-delay="500"
                        data-sal-duration="800">
                        <!-- <div class="image">

                                <img src="assets/images/about/01.svg" alt="">
                            </div> -->
                        <div class="description">
                            <!-- <h6>Web Hosting</h6> -->
                            <p>At Knot Host, we understand the importance of standing out in the digital landscape. Just
                                as you strive for uniqueness, we offer tailored solutions to help you thrive online. Our
                                team of experts is integral to Knot Host being the perfect home for your website or
                                platform. Whether you require a website hosting plan, email solution or a professional
                                website design for your business, Knot Host is your ideal solution. Our powerful hosting
                                services not only aid in achieving your goals but also provide the assurance of a
                                reliable and secure platform. Trust Knot Host for your hosting needs and embark on a
                                journey towards online success.
                            </p>
                        </div>
                    </div>
                    <!-- <div class="rts-about__content--single" data-sal="slide-down" data-sal-delay="600"
                            data-sal-duration="800">
                            <div class="image bg-2">
                                <img src="assets/images/about/02.svg" alt="">
                            </div>
                            <div class="description">
                                <h6>Managed WordPress Hosting</h6>
                                <p>Our Managed WordPress Hosting gives you speed and performance with a full set of
                                    features.</p>
                            </div>
                        </div> -->
                </div>
            </div>
        </div>
    </div>
    <div class="rts-about-shape"></div>
</div>
<!-- ABOUT US END -->


<!-- DATA CENTER AREA -->
<div class="rts-data-center fix">
    <div class="container">
        <div class="row justify-content-center">
            <div class="rts-section w-790 text-center">
                <h3 class="rts-section__title" data-sal="slide-down" data-sal-delay="300" data-sal-duration="800">
                    Data Centers Unleashed: Where Innovation Meets Reliability</h3>
                <p class="rts-section__description" data-sal="slide-down" data-sal-delay="400" data-sal-duration="800">
                    Our web hosting, WordPress hosting, and E-Mail hosting plans offer
                    server
                    locations in: France and India.
                </p>
            </div>
        </div>
        <!-- data center content -->
        <div class="row">
            <div class="col-12">
                <div class="rts-data-center__location">
                    <img src="assets/images/datacenter2.svg" alt="data__center">
                    <ul class="round-shape">
                        <!-- <li class="one">
                                <span class="tolltip1" data-bs-toggle="tooltip" data-bs-placement="top"
                                    data-bs-custom-class="color-knothost" title="Canada"></span>
                                <img src="assets/images/flag-01.svg" alt="">
                            </li> -->
                        <li class="two">
                            <span class="tolltip1" data-bs-toggle="tooltip" data-bs-placement="top"
                                data-bs-custom-class="color-knothost" title="France"></span>
                            <img src="assets/images/frenchflag.svg" alt="">
                        </li>
                        <!-- <li class="three">
                                <span class="tolltip1" data-bs-toggle="tooltip" data-bs-placement="top"
                                    data-bs-custom-class="color-knothost" title="Russia"></span>
                                <img src="assets/images/flag-03.svg" alt="">
                            </li> -->
                        <!-- <li class="four">
                                <span class="tolltip1" data-bs-toggle="tooltip" data-bs-placement="top"
                                    data-bs-custom-class="color-knothost" title="USA"></span>
                                <img src="assets/images/flag-04.svg" alt="">
                            </li>
                            <li class="five">
                                <span class="tolltip1" data-bs-toggle="tooltip" data-bs-placement="top"
                                    data-bs-custom-class="color-knothost" title="Egypt"></span>
                                <img src="assets/images/flag-05.svg" alt="">
                            </li> -->
                        <li class="six">
                            <span class="tolltip1" data-bs-toggle="tooltip" data-bs-placement="top"
                                data-bs-custom-class="color-knothost" title="India"></span>
                            <img src="assets/images/flag-06.svg" alt="">
                        </li>
                        <!-- <li class="seven">
                                <span class="tolltip1" data-bs-toggle="tooltip" data-bs-placement="top"
                                    data-bs-custom-class="color-knothost" title="China"></span>
                                <img src="assets/images/flag-07.svg" alt="">
                            </li>
                            <li class="eight">
                                <span class="tolltip1" data-bs-toggle="tooltip" data-bs-placement="top"
                                    data-bs-custom-class="color-knothost" title="Brazil"></span>
                                <img src="assets/images/flag-08.svg" alt="">
                            </li>
                            <li class="nine">
                                <span class="tolltip1" data-bs-toggle="tooltip" data-bs-placement="top"
                                    data-bs-custom-class="color-knothost" title="South Africa"></span>
                                <img src="assets/images/flag-09.svg" alt="">
                            </li>
                            <li class="ten">
                                <span class="tolltip1" data-bs-toggle="tooltip" data-bs-placement="top"
                                    data-bs-custom-class="color-knothost" title="Australia"></span>
                                <img src="assets/images/flag-10.svg" alt="">
                            </li> -->
                    </ul>
                </div>
            </div>
        </div>
    </div>
    <div class="rts-shape">
        <div class="rts-shape__one"></div>
        <div class="rts-shape__two"></div>
        <div class="rts-shape__three"></div>
        <div class="rts-shape__four"></div>
    </div>
</div>
<!-- DATA CENTER AREA END -->


<!-- AFFILIATE FEATURE -->
<div class="rts-affiliate-feature  ">
    <div class="container">
        <div class="row .align-items-center .justify-content-md-center g-30">
            <h3 class="title">Your Trusted Web Hosting Partner</h3>
        </div>
        <div class="row align-items-center justify-content-md-center g-30">
            <div class="col-lg-6">
                <div class="affiliate-feature-img">
                    <img src="assets/images/indexhomepage.jpg" height="500" width="645" alt="">
                </div>
            </div>
            <div class="col-lg-5">
                <div class="affiliate-feature-content">
                    <!-- <h3 class="title">We are with you every step of the way</h3> -->
                    <p class="description">Explore personal and business website hosting plans with Knot Host. Our
                        experienced team ensures reliable and secure hosting, empowering your online goals.</p>
                    <div class="single-feature">
                        <div class="single-item">
                            <div class="icon">
                                <img src="assets/images/affiliate/feature-1.svg" alt="">
                            </div>
                            <h5 class="content">14 Plus Years of Hosting Experience</h5>
                        </div>
                        <div class="single-item">
                            <div class="icon">
                                <img src="assets/images/affiliate/feature-2.svg" alt="">
                            </div>
                            <h5 class="content">Professional 24/7 Support Team</h5>
                        </div>
                        <div class="single-item">
                            <div class="icon">
                                <img src="assets/images/affiliate/feature-3.svg" alt="">
                            </div>
                            <h5 class="content">Dedicated Support Ticket Team</h5>
                        </div>
                    </div>
                </div>
            </div>
        </div>

    </div>
</div>
<!-- AFFILIATE FEATURE END -->

<!-- WHY CHOOSE US -->
<section class="rts-whychoose section__padding">
    <div class="container">
        <div class="row align-items-center">
            <div class="col-lg-5 order-change">
                <div class="rts-whychoose__content">
                    <h3 class="rts-whychoose__content--title">Why Choose Knot Host for Your Web Solutions</h3>

                    <!-- single content-->
                    <div class="single">
                        <div class="single__image">
                            <img src="assets/images/icon/speed.svg" alt="">
                        </div>
                        <div class="single__content">
                            <h6>Experience Lightning-Fast Web Hosting</h6>
                            <p>With our high-speed servers, your website will load quickly, enhancing user experience
                                and SEO performance.</p>
                        </div>
                    </div>
                    <!-- single content-->
                    <div class="single">
                        <div class="single__image bg1">
                            <img src="assets/images/icon/support.svg" alt="">
                        </div>
                        <div class="single__content">
                            <h6>Expert Assistance 24/7</h6>
                            <p>Our knowledgeable support team is available round-the-clock to assist you with domain
                                names, website design, and web hosting queries.</p>
                        </div>
                    </div>
                    <!-- single content-->
                    <div class="single">
                        <div class="single__image">
                            <img src="assets/images/icon/money-back.svg" alt="">
                        </div>
                        <div class="single__content">
                            <h6>Try Our Services Risk-Free</h6>
                            <p>Sign up for our hosting solutions risk-free, and if you're not satisfied, we offer a
                                money-back guarantee.</p>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-6 offset-lg-1">
                <div class="rts-whychoose__image">
                    <img src="assets/images/whychoose.svg" alt="">
                    <img src="assets/images/paper-plane.svg" alt="" class="shape one bottom-top">
                    <img src="assets/images/wifi.svg" alt="" class="shape two right-left">
                </div>
            </div>
        </div>
    </div>
    <div class="rts-shape">
        <div class="rts-shape__one"></div>
    </div>
</section>
<!-- WHY CHOOSE US END -->



<!-- Frequently Asked Questions -->
<!-- <section class="rts-faq section__padding">
    <div class="container">
        <div class="row">
            <div class="col-lg-5">
                <div class="rts-faq__first">
                    <h3 class="title" data-sal="slide-down" data-sal-delay="300" data-sal-duration="800">Frequently
                        Asked Questions About Knot Host</h3>
                    <p data-sal="slide-down" data-sal-delay="400" data-sal-duration="800">Get answers to common queries
                        about our web hosting, email hosting, and website design services at Knot Host.</p>
                    <img data-sal="slide-down" data-sal-delay="500" data-sal-duration="800"
                        src="assets/images/faq/faq.svg" alt="faq">
                    <div class="rts-faq__first--shape">
                        <div class="img"><img src="assets/images/faq/faq__animated.svg" alt=""></div>
                    </div>
                </div>
            </div>
            <div class="col-lg-6 offset-lg-1">
                <div class="rts-faq__accordion">
                    <div class="accordion accordion-flush" id="rts-accordion">
                        <div class="accordion-item active" data-sal="slide-left" data-sal-delay="300"
                            data-sal-duration="800">
                            <div class="accordion-header" id="first">
                                <h4 class="accordion-button collapse show" data-bs-toggle="collapse"
                                    data-bs-target="#item__one" aria-expanded="false" aria-controls="item__one">What
                                    Hosting Plans Does Knot Host Offer?</h4>
                            </div>
                            <div id="item__one" class="accordion-collapse collapse collapse show"
                                aria-labelledby="first" data-bs-parent="#rts-accordion">
                                <div class="accordion-body">
                                    Discover our range of hosting plans, including shared hosting, VPS hosting, and
                                    dedicated server hosting.
                                </div>
                            </div>
                        </div>
                        <div class="accordion-item" data-sal="slide-left" data-sal-delay="400" data-sal-duration="800">
                            <div class="accordion-header" id="two">
                                <h4 class="accordion-button collapsed" data-bs-toggle="collapse"
                                    data-bs-target="#item__two" aria-expanded="false" aria-controls="item__two">How Does
                                    Knot Host Ensure Website Security?</h4>
                            </div>
                            <div id="item__two" class="accordion-collapse collapse" aria-labelledby="two"
                                data-bs-parent="#rts-accordion">
                                <div class="accordion-body">
                                    Learn about our security measures to protect websites hosted on our platform.
                                </div>
                            </div>
                        </div>
                        <div class="accordion-item" data-sal="slide-left" data-sal-delay="500" data-sal-duration="800">
                            <div class="accordion-header" id="three">
                                <h4 class="accordion-button collapsed" data-bs-toggle="collapse"
                                    data-bs-target="#item__three" aria-expanded="false" aria-controls="item__three">
                                    What Web Design Services Does Knot Host Offer?</h4>
                            </div>
                            <div id="item__three" class="accordion-collapse collapse" aria-labelledby="three"
                                data-bs-parent="#rts-accordion">
                                <div class="accordion-body">
                                    Explore our web design services, including responsive website development and
                                    e-commerce solutions.
                                </div>
                            </div>
                        </div>

                        <div class="accordion-item" data-sal="slide-left" data-sal-delay="600" data-sal-duration="800">
                            <div class="accordion-header" id="four">
                                <h4 class="accordion-button collapsed" data-bs-toggle="collapse"
                                    data-bs-target="#item__four" aria-expanded="false" aria-controls="item__four">
                                    How Does Knot Host Ensure Email Deliverability?</h4>
                            </div>
                            <div id="item__four" class="accordion-collapse collapse" aria-labelledby="four"
                                data-bs-parent="#rts-accordion">
                                <div class="accordion-body">
                                    Learn about our email hosting practices to ensure reliable email delivery.
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section> -->
<!-- FAQ END -->


<!-- CTA AREA -->
<div class="rts-cta">
    <div class="container">
        <div class="row">
            <div class="rts-cta__wrapper">
                <div class="rts-cta__left">
                    <h3 class="cta__title" data-sal="slide-down" data-sal-delay="300" data-sal-duration="800">
                        Buy Your Domain & Web Hosting - Experience the Knothost Difference!
                    </h3>
                    <p data-sal="slide-down" data-sal-delay="400" data-sal-duration="800">
                        Search for Your Perfect Domain Name & Get Reliable Web Hosting - All at Knothost!
                    </p>
                    <a data-sal="slide-down" data-sal-delay="500" data-sal-duration="800" href="domain.php"
                        class="primary__btn secondary__bg">
                        Get Your Domain & Hosting Now! <i class="fa-regular fa-arrow-right"></i>
                    </a>
                </div>
                <div class="rts-cta__right">
                    <div class="cta-image">
                        <div class="cta-image__one">
                            <img src="assets/images/cta/cta__hosting.svg" alt="Knothost Web Hosting">
                        </div>
                        <div class="cta-image__two">
                            <img src="assets/images/cta/cta__person.svg"
                                alt="Happy Customer with Knothost Domain & Hosting">
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- CTA AREA END  -->

<!-- BRAND AREA -->
<div class="rts-brand rts-brand__bg--section pt-100">
    <div class="container">
        <div class="row">
            <div class="col-lg-12">
                <div class="rts-brand__wrapper">
                    <div class="rts-brand__wrapper--text">
                        <h3 data-sal="slide-down" data-sal-delay="300" data-sal-duration="800">Easy 1-Click App
                            Installs! Optimized Hosting for Popular Apps.
                        </h3>
                        <!-- <div class="rts-brand__wrapper--text-review" data-sal="slide-down" data-sal-delay="400"
                                data-sal-duration="800">
                                <div class="review">
                                    <div class="star">Excellent <img src="assets/images/brand/review-star.svg" alt="">
                                    </div>
                                </div>
                                <div class="review__company">
                                    954 reviews on <img src="assets/images/brand/trust-pilot.svg" alt="">
                                </div>
                            </div> -->
                    </div>
                    <div class="rts-brand__slider">
                        <div class="swiper-wrapper">
                            <div class="swiper-slide">
                                <div class="rts-brand__slider--single">
                                    <a href="#"><img
                                            src="http://dubaiwebdesigner.ae/asset/img/famework/famework-icon-1.png"
                                            alt="">
                                        <h2>JOOMLA</h2>
                                    </a>
                                </div>
                            </div>
                            <div class="swiper-slide">
                                <div class="rts-brand__slider--single">
                                    <a href="#"><img
                                            src="http://dubaiwebdesigner.ae/asset/img/famework/famework-icon-2.png"
                                            alt="">
                                        <h2>MAGENTO</h2>
                                    </a>
                                </div>
                            </div>
                            <div class="swiper-slide">
                                <div class="rts-brand__slider--single">
                                    <a href="#"><img
                                            src="http://dubaiwebdesigner.ae/asset/img/famework/famework-icon-3.png"
                                            alt="">
                                        <h2>OPENCART</h2>
                                    </a>
                                </div>
                            </div>
                            <div class="swiper-slide">
                                <div class="rts-brand__slider--single">
                                    <a href="#"><img
                                            src="http://dubaiwebdesigner.ae/asset/img/famework/famework-icon-4.png"
                                            alt="">
                                        <h2>WORDPRESS</h2>
                                    </a>
                                </div>
                            </div>
                            <div class="swiper-slide">
                                <div class="rts-brand__slider--single">
                                    <a href="#"><img
                                            src="https://upload.wikimedia.org/wikipedia/commons/b/b6/Intel_Xeon_Official_Logo_2020.png"
                                            alt="">
                                        <h2>INTEL XEON</h2>
                                    </a>
                                </div>
                            </div>
                            <div class="swiper-slide">
                                <div class="rts-brand__slider--single">
                                    <a href="#"><img
                                            src="https://upload.wikimedia.org/wikipedia/commons/a/af/Tux.png?20070323032439"
                                            alt="">
                                        <h2>LINUX</h2>
                                    </a>
                                </div>
                            </div>
                            <div class="swiper-slide">
                                <div class="rts-brand__slider--single">
                                    <a href="#"><img
                                            src="http://dubaiwebdesigner.ae/asset/img/famework/famework-icon-5.png"
                                            alt="">
                                        <h2>DRUPAL</h2>
                                    </a>
                                </div>
                            </div>
                            <div class="swiper-slide">
                                <div class="rts-brand__slider--single">
                                    <a href="#"><img
                                            src="http://dubaiwebdesigner.ae/asset/img/famework/famework-icon-1.png"
                                            alt="">
                                        <h2>JOOMLA</h2>
                                    </a>
                                </div>
                            </div>
                            <div class="swiper-slide">
                                <div class="rts-brand__slider--single">
                                    <a href="#"><img
                                            src="http://dubaiwebdesigner.ae/asset/img/famework/famework-icon-2.png"
                                            alt="">
                                        <h2>MAGENTO</h2>
                                    </a>
                                </div>
                            </div>
                            <div class="swiper-slide">
                                <div class="rts-brand__slider--single">
                                    <a href="#"><img
                                            src="http://dubaiwebdesigner.ae/asset/img/famework/famework-icon-3.png"
                                            alt="">
                                        <h2>OPENCART</h2>
                                    </a>
                                </div>
                            </div>
                            <div class="swiper-slide">
                                <div class="rts-brand__slider--single">
                                    <a href="#"><img
                                            src="http://dubaiwebdesigner.ae/asset/img/famework/famework-icon-4.png"
                                            alt="">
                                        <h2>WORDPRESS</h2>
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>

                </div>
            </div>
        </div>
    </div>
</div>
<!-- BRAND AREA END-->

<?php include ("layout/footer.php") ?>