<?php
$pricingPlans = array(
    array(
        'name' => 'Starter',
        'icon' => 'assets/images/pricing/basic.svg',
        'description' => 'All the essentials for launching your website',
        'monthly_price' => 5.50,
        'yearly_price' => 59,
        'discount' => 20,
        'renewPrice' => 5.50,
        'features' => array(
            'Disk Space(SSD)' => array('value' => '5 GB', 'show_check' => true),
            'Monthly Bandwidth' => array('value' => 'Unlimited', 'show_check' => true),
            'FTP Accounts' => array('value' => 10, 'show_check' => true),
            'Email Accounts' => array('value' => 1, 'show_check' => true),
            'Databases' => array('value' => 1, 'show_check' => true),
            'Sub Domains' => array('value' => 20, 'show_check' => true),
            'Parked Domains' => array('value' => 0, 'show_check' => false),
            'Website Builder' => array('value' => 'Not Included', 'show_check' => false),
            'SSL Certificate' => array('value' => 'Free', 'show_check' => true),
            'Antivirus' => array('value' => 'Free', 'show_check' => true),
            'Backup' => array('value' => 'Daily', 'show_check' => true),
            'Premium Support' => array('value' => 'Yes', 'show_check' => true),
            'Addon Domains' => array('value' => 0, 'show_check' => false),
        ),
        'link' => 'https://www.knothost.com/billing/cart.php?a=add&pid=50&sld=whmcs&tld=.com',
        'featured' => false
    ),
    array(
        'name' => 'Basic',
        'icon' => 'assets/images/pricing/premium.svg',
        'description' => 'Enhance your website with advanced tools',
        'monthly_price' => 8.41,
        'yearly_price' => 89,
        'discount' => 20,
        'renewPrice' => 8.41,
        'features' => array(
            'Disk Space(SSD)' => array('value' => '10 GB', 'show_check' => true),
            'Monthly Bandwidth' => array('value' => 'Unlimited', 'show_check' => true),
            'FTP Accounts' => array('value' => 'Unlimited', 'show_check' => true),
            'Email Accounts' => array('value' => 15, 'show_check' => true),
            'Databases' => array('value' => 'Unlimited', 'show_check' => true),
            'Sub Domains' => array('value' => 'Unlimited', 'show_check' => true),
            'Parked Domains' => array('value' => 'Unlimited', 'show_check' => true),
            'Website Builder' => array('value' => 'Included', 'show_check' => true),
            'SSL Certificate' => array('value' => 'Free', 'show_check' => true),
            'Antivirus' => array('value' => 'Free', 'show_check' => true),
            'Backup' => array('value' => 'Daily', 'show_check' => true),
            'Premium Support' => array('value' => 'Yes', 'show_check' => true),
            'Addon Domains' => array('value' => 2, 'show_check' => true),
        ),
        'link' => 'https://www.knothost.com/billing/cart.php?a=add&pid=51&sld=whmcs&tld=.com',
        'featured' => false
    ),
    array(
        'name' => 'Business',
        'icon' => 'assets/images/pricing/business.svg',
        'description' => 'Comprehensive solutions for your business needs',
        'monthly_price' => 9.99,
        'yearly_price' => 109,
        'discount' => 20,
        'renewPrice' => 9.99,
        'features' => array(
            'Disk Space(SSD)' => array('value' => '20 GB', 'show_check' => true),
            'Monthly Bandwidth' => array('value' => 'Unlimited', 'show_check' => true),
            'FTP Accounts' => array('value' => 'Unlimited', 'show_check' => true),
            'Email Accounts' => array('value' => 25, 'show_check' => true),
            'Databases' => array('value' => 'Unlimited', 'show_check' => true),
            'Sub Domains' => array('value' => 'Unlimited', 'show_check' => true),
            'Parked Domains' => array('value' => 'Unlimited', 'show_check' => true),
            'Website Builder' => array('value' => 'Included', 'show_check' => true),
            'SSL Certificate' => array('value' => 'Free', 'show_check' => true),
            'Antivirus' => array('value' => 'Free', 'show_check' => true),
            'Backup' => array('value' => 'Daily', 'show_check' => true),
            'Premium Support' => array('value' => 'Yes', 'show_check' => true),
            'Addon Domains' => array('value' => 2, 'show_check' => true),
        ),
        'link' => 'https://www.knothost.com/billing/cart.php?a=add&pid=54&sld=whmcs&tld=.com',
        'featured' => true
    ),
    array(
        'name' => 'Enterprise',
        'icon' => 'assets/images/pricing/cloud.svg',
        'description' => 'Robust infrastructure for large-scale operations',
        'monthly_price' => 34.99,
        'yearly_price' => 399,
        'discount' => 20,
        'renewPrice' => 34.99,
        'features' => array(
            'Disk Space(SSD)' => array('value' => '50 GB', 'show_check' => true),
            'Monthly Bandwidth' => array('value' => 'Unlimited', 'show_check' => true),
            'FTP Accounts' => array('value' => 'Unlimited', 'show_check' => true),
            'Email Accounts' => array('value' => 50, 'show_check' => true),
            'Databases' => array('value' => 'Unlimited', 'show_check' => true),
            'Sub Domains' => array('value' => 'Unlimited', 'show_check' => true),
            'Parked Domains' => array('value' => 'Unlimited', 'show_check' => true),
            'Website Builder' => array('value' => 'Included', 'show_check' => true),
            'SSL Certificate' => array('value' => 'Free', 'show_check' => true),
            'Antivirus' => array('value' => 'Free', 'show_check' => true),
            'Backup' => array('value' => 'Daily', 'show_check' => true),
            'Premium Support' => array('value' => 'Yes', 'show_check' => true),
            'Addon Domains' => array('value' => 5, 'show_check' => true),
        ),
        'link' => 'https://www.knothost.com/billing/cart.php?a=add&pid=55&sld=whmcs&tld=.com',
        'featured' => false
    )
);
echo $_SERVER['SERVER_NAME'];
$cookie_name = "market";
$development = false;
if($_SERVER['SERVER_NAME'] == 'sa.knothost.com'){
    $cookie_value = "saudi_arabia";
    setcookie($cookie_name, $cookie_value, time() + (301556952), "/");
    header('Location: https://sa.knothost.com');
}else if($_SERVER['SERVER_NAME'] == 'ae.knothost.com'){
    $cookie_value = "uae";
    setcookie($cookie_name, $cookie_value, time() + (301556952), "/");
    header('Location: https://ae.knothost.com');
}else if($_SERVER['SERVER_NAME'] == 'localhost'){
    $development = true;
    $cookie_value = "development";
    setcookie($cookie_name, $cookie_value, time() + (301556952), "/");
}else if($_SERVER['SERVER_NAME'] == 'knothost.com'){
    if($_COOKIE[$cookie_name] == 'saudi_arabia'){
        header('Location: https://sa.knothost.com');
    }else if($_COOKIE[$cookie_name] == 'uae'){
        header('Location: https://ae.knothost.com');
    }else {
        $cookie_value = "international";
        setcookie($cookie_name, $cookie_value, time() + (301556952), "/");
        header('Location: https://knothost.com');
    }
}else {
    $cookie_value = "international";
    setcookie($cookie_name, $cookie_value, time() + (301556952), "/");
    header('Location: https://sa.knothost.com');
}
echo "Value is: " . $_COOKIE[$cookie_name];
?>


<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <?php require ("metadata.php") ?>
    <link rel="icon" type="image/x-icon" href="assets/images/logo/favicon.ico">
    <?php
    if (array_key_exists($pageName, $metaTags)) {
        $title = $metaTags[$pageName]['title'];
        $description = $metaTags[$pageName]['description'];
        $keywords = $metaTags[$pageName]['keywords'];
        $og_image = $metaTags[$pageName]['og_image'];
        ?>
        <title><?php echo $title; ?></title>
        <meta name="description" content="<?php echo $description; ?>">
        <meta name="keywords" content="<?php echo $keywords; ?>">
        <meta property="og:title" content="<?php echo $title; ?>">
        <meta property="og:description" content="<?php echo $description; ?>">
        <meta property="og:type" content="website">
        <meta property="og:url" content="https://knothost.com/<?php echo $pageName; ?>">
        <meta property="og:image" content="https://knothost.com/<?php echo $og_image; ?>">
    <?php } ?>

    <!-- bootstrap css -->
    <link rel="stylesheet preload" href="assets/css/vendor/bootstrap.min.css" as="style">
    <!-- fontawesome css -->
    <link rel="stylesheet preload" href="assets/css/plugins/fontawesome.min.css" as="style">
    <!-- swiper css -->
    <link rel="stylesheet preload" href="assets/css/plugins/swiper.min.css" as="style">
    <!-- magnific popup css -->
    <link rel="stylesheet preload" href="assets/css/plugins/magnific-popup.css" as="style">
    <!-- aos css -->
    <!-- <link  rel="stylesheet preload" href="assets/css/plugins/aos.min.css" as="style"> -->
    <link rel="stylesheet preload" href="assets/css/plugins/sal.min.css" as="style">
    <!-- nice select css -->
    <link rel="stylesheet preload" href="assets/css/plugins/nice-select.css" as="style">
    <!-- metismenu css -->
    <link rel="stylesheet preload" href="assets/css/plugins/metismenu.css" as="style">
    <!-- Custom css -->
    <link rel="stylesheet preload" href="assets/css/style.css" as="style">

    <link rel="stylesheet preload" href="assets/css/plugins/dynamicselect.css" as="style">
    <script>
        var onloadCallback = function () {
            if (document.getElementById('formRecatpcha')) {
                formRecatpcha = grecaptcha.render(document.getElementById('formRecatpcha'), {
                    'sitekey': '6LdQE6EdAAAAAOLWdkqAhgqe7Bt49lzXHkIVPv1z',
                });
            }
            if (document.getElementById('footerRecaptcha')) {
                footerRecaptcha = grecaptcha.render(document.getElementById('footerRecaptcha'), {
                    'sitekey': '6LdQE6EdAAAAAOLWdkqAhgqe7Bt49lzXHkIVPv1z',
                });
            }
        }
    </script>
</head>

<body>

    <!-- HEADER AREA -->
    <header class="rts-header style-one header__default">
        <!-- HEADER TOP AREA -->
        <div class="rts-ht rts-ht__bg">
            <div class="container">
                <div class="row">
                    <div class="rts-ht__wrapper">
                        <div class="rts-ht__email">
                            <a href="mailto:info@knothost.com"><img src="assets/images/icon/email.svg" alt=""
                                    class="icon">info@knothost.com</a>
                        </div>
                        <div class="rts-ht__promo">
                            <p><img class="icon" src="assets/images/icon/tag--group.svg" alt=""> Hosting Flash Sale:
                                Starting at <strong><span class="price"
                                        data-initial-price="4.40">$4.40</span>/mo</strong> for a limited time</p>
                        </div>
                        <div class="rts-ht__links">
                            <div class="live-chat-has-dropdown">
                                <a href="tel:+971585408365" class="live__chat"><img src="assets/images/icon/forum.svg"
                                        alt="" class="icon">Call Us</a>
                            </div>
                            <div class="login-btn-has-dropdown">
                                <a href="https://www.knothost.com/billing/clientarea.php" class="login__link"><img
                                        src="assets/images/icon/person.svg" alt="" class="icon">Login</a>
                                <div class="login-submenu">
                                    <form method="post" action="https://www.knothost.com/billing/dologin.php">
                                        <div class="form-inner">
                                            <div class="single-wrapper">
                                                <input type="email" placeholder="Your email" name="username" size="50"
                                                    required>
                                            </div>
                                            <div class="single-wrapper">
                                                <input type="password" placeholder="Password" name="password" size="20"
                                                    autocomplete="off" required>
                                            </div>
                                            <div class="form-btn">
                                                <button type="submit" class="primary__btn">Log In</button>
                                            </div>
                                            <a href="#" class="forgot-password">Forgot your password?</a>
                                        </div>
                                    </form>
                                </div>
                            </div>
                            <!-- Currency Select -->
                            <select id="currency-select" title="currency_select" name="country-select"
                                data-dynamic-select>
                                <option value="usd" data-img="https://flagicons.lipis.dev/flags/4x3/us.svg"
                                    data-img-width="16px"> USD</option>
                                <option value="aed" data-img="https://flagicons.lipis.dev/flags/4x3/ae.svg"
                                    data-img-width="16px"> AED</option>
                                <option value="inr" data-img="assets/images/flag-06.svg" data-img-width="16px"> INR
                                </option>
                            </select>

                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- HEADER TOP AREA END -->
        <div class="container">
            <div class="row">
                <div class="rts-header__wrapper">
                    <!-- FOR LOGO -->
                    <div class="rts-header__logo">
                        <a href="index.php" class="site-logo">
                            <img class="logo-white" src="assets/images/logo/knothost_icon_background_white.svg"
                                alt="Knothost Logo" width="40" height="40">
                            <img class="logo-dark" src="assets/images/logo/knothost_icon_background_white.svg"
                                alt="Knothost Logo" height="40" width="40">
                            <h4><span class="logo-text-bold">Knot</span>Host</h4>
                        </a>
                    </div>

                    <!-- Navbar -->
                    <?php include ("layout/navbar.php") ?>
                    <!-- For Header Right -->
                    <div class="rts-header__right">
                        <a href="https://knothost.com/billing/clientarea.php" class="login__btn">Client
                            Area</a>
                        <button id="menu-btn" class="mobile__active menu-btn"><i
                                class="fa-sharp fa-solid fa-bars"></i></button>
                    </div>
                </div>
            </div>
        </div>
    </header>

    <div class="data-div" data-exchange-rates="" data-selected-currency="" style="display:none;">

    </div>
    <!-- HEADER AREA END -->