<?php include ("layout/header.php") ?>
<style>
    /* @media (min-width:991px) {
        .rts-header {
            position: relative;
        }

        .rts-hosting-banner.banner-default-height {
            min-height: 500px;
        }
    } */
</style>
<!-- Logo Design Banner -->
<div class="rts-hosting-banner rts-hosting-banner-bg banner-default-height">
    <div class="container">
        <div class="row justify-content-sm-center">
            <div class="banner-area">
                <div class="rts-hosting-banner rts-hosting-banner__content">
                    <span class="starting__price" data-sal="slide-down" data-sal-delay="100"
                        data-sal-duration="800">Logo Design</span>
                    <h1 class="banner-title" data-sal="slide-down" data-sal-delay="200" data-sal-duration="800">
                        Unleash Your Brand's Identity with Captivating Logos
                    </h1>
                    <p class="slogan" data-sal="slide-down" data-sal-delay="300" data-sal-duration="800">Craft a logo
                        that speaks volumes about your brand personality</p>
                    <div class="hosting-action">
                        <a href="#quote_form" class="btn__two secondary__bg secondary__color">Get Started <i
                                class="fa-regular fa-arrow-right"></i></a>
                    </div>
                </div>
                <div class="rts-hosting-banner__image vps">
                    <img src="assets/images/banner/logodesign.svg" alt="Logo Design Illustration">
                    <img class="shape-image one top-bottom2" src="assets/images/banner/banner__vps__image-sm1.svg"
                        alt="VPS Image">
                </div>
            </div>
        </div>
    </div>
</div>
<!-- Logo Design Banner End -->


<!-- Logo Design Feature Section -->
<section class="rts-feature section__padding">
    <div class="container">
        <div class="row g-30 align-items-stretch">
            <div class="col-lg-6 d-flex align-items-center">
                <div class="rts-feature-section">
                    <h2 class="title" data-sal="slide-down" data-sal-delay="100" data-sal-duration="800">
                        Explore Our Logo Design Services
                    </h2>
                    <p data-sal="slide-down" data-sal-delay="200" data-sal-duration="800">
                        Elevate your brand identity with our professional logo design solutions. Join thousands of
                        satisfied clients who trust us with their visual representation.
                    </p>
                </div>
            </div>
            <!-- Logo Design Feature Cards -->
            <div class="col-lg-3 col-md-4 col-sm-6" data-sal="slide-down" data-sal-delay="300" data-sal-duration="800">
                <div class="card-feature h-100">
                    <div class="card-feature__single">
                        <div class="card-feature__single--icon">
                            <i class="fas fa-paint-brush"></i>
                        </div>
                        <h5 class="card-feature__single--title">
                            Custom Logo Designs
                        </h5>
                        <p class="card-feature__single--description">
                            Stand out from the competition with a unique logo tailored to your brand's personality and
                            values.
                        </p>
                    </div>
                </div>
            </div>
            <!-- Second Card -->
            <div class="col-lg-3 col-md-4 col-sm-6" data-sal="slide-down" data-sal-delay="400" data-sal-duration="800">
                <div class="card-feature h-100">
                    <div class="card-feature__single">
                        <div class="card-feature__single--icon">
                            <i class="fas fa-id-card"></i>
                        </div>
                        <h5 class="card-feature__single--title">
                            Professional Branding
                        </h5>
                        <p class="card-feature__single--description">
                            Establish credibility and professionalism with cohesive branding elements including logos,
                            color schemes, and fonts.
                        </p>
                    </div>
                </div>
            </div>
            <!-- Third Card -->
            <div class="col-lg-3 col-md-4 col-sm-6" data-sal="slide-down" data-sal-delay="500" data-sal-duration="800">
                <div class="card-feature h-100">
                    <div class="card-feature__single">
                        <div class="card-feature__single--icon">
                            <i class="fas fa-laptop"></i>
                        </div>
                        <h5 class="card-feature__single--title">
                            Versatile Designs
                        </h5>
                        <p class="card-feature__single--description">
                            Get logo designs that look great across various platforms and mediums, ensuring maximum
                            brand visibility.
                        </p>
                    </div>
                </div>
            </div>
            <!-- Fourth Card -->
            <div class="col-lg-3 col-md-4 col-sm-6" data-sal="slide-down" data-sal-delay="600" data-sal-duration="800">
                <div class="card-feature h-100">
                    <div class="card-feature__single">
                        <div class="card-feature__single--icon">
                            <i class="fas fa-clock"></i>
                        </div>
                        <h5 class="card-feature__single--title">
                            Timely Delivery
                        </h5>
                        <p class="card-feature__single--description">
                            We understand the importance of deadlines. Get your logo designs delivered on time, every
                            time.
                        </p>
                    </div>
                </div>
            </div>
            <!-- Fifth Card -->
            <div class="col-lg-3 col-md-4 col-sm-6" data-sal="slide-down" data-sal-delay="700" data-sal-duration="800">
                <div class="card-feature h-100">
                    <div class="card-feature__single">
                        <div class="card-feature__single--icon">
                            <i class="fas fa-sync-alt"></i>
                        </div>
                        <h5 class="card-feature__single--title">
                            Unlimited Revisions
                        </h5>
                        <p class="card-feature__single--description">
                            We work closely with you to ensure your complete satisfaction, offering unlimited revisions
                            until you're happy with the result.
                        </p>
                    </div>
                </div>
            </div>
            <!-- Sixth Card -->
            <div class="col-lg-3 col-md-4 col-sm-6" data-sal="slide-down" data-sal-delay="800" data-sal-duration="800">
                <div class="card-feature h-100">
                    <div class="card-feature__single">
                        <div class="card-feature__single--icon">
                            <i class="fas fa-user-tie"></i>
                        </div>
                        <h5 class="card-feature__single--title">
                            Expert Designers
                        </h5>
                        <p class="card-feature__single--description">
                            Our team of experienced designers brings creativity and expertise to every logo design
                            project, ensuring outstanding results.
                        </p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<!-- Logo Design Feature Section End -->




<!-- Get a Quote section for Logo Design -->
<section class="rts-contact-form support section__padding" id="quote_form">
    <div class="container">
        <div class="row gy-30 justify-content-center align-items-center">
            <div class="col-xl-6 col-lg-6 col-md-10 mt-0">
                <div class="contact-form">
                    <div class="contact-form__content" data-sal="slide-down" data-sal-delay="100"
                        data-sal-duration="800">
                        <div class="contact-form__content--image">
                            <img src="assets/images/contact/contact-form.png" width="260" height="188" alt="">
                        </div>
                        <h1 class="contact-form__content--title">
                            Get a Quote for Logo Design
                        </h1>
                        <p class="contact-form__content--description">
                            Arrange a consultation with us, and our seasoned professionals will craft an exclusive and
                            unforgettable logo design tailored to elevate your brand identity.
                        </p>
                        <div class="contact__shape support-page">
                            <img src="assets/images/contact/contact__animated__arrow.svg" alt="">
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-xl-5 col-lg-6 offset-xl-1 col-md-10">
                <div class="form">
                    <form class="form__content" method="post" action="quoteService.php" id="quoteServiceform">
                        <input type="hidden" name="service" value="Logo Design">
                        <div class="form__control">
                            <input type="text" class="input-form" name="name" placeholder="Your Name" required>
                            <input type="email" class="input-form" name="email" placeholder="Your Email" required>
                        </div>
                        <div class="form__control">
                            <input type="tel" class="input-form" name="phone" placeholder="Your Phone" required>
                            <select name="budget" id="budget2" class="input-form" required>
                                <option value="">Your Budget</option>
                                <option value="0 - 100 USD">0 - 100 USD</option>
                                <option value="100 - 500 USD">100 - 500 USD</option>
                                <option value="501 - 1000 USD">501 - 1000 USD</option>
                            </select>
                        </div>
                        <div class="form__control">
                            <textarea name="message" class="input-form" rows="5" placeholder="Your Message"
                                required></textarea>
                        </div>
                        <div id="toast-container-quoteService" class="toast-container" style="display:none;">
                            <div id="toast-success-quoteService" class="toast toast-success" role="alert"
                                aria-live="assertive" aria-atomic="true">
                                <div class="toast-content">
                                    <i class="toast-icon fas fa-check-circle"></i>
                                    <div class="toast-message"></div>
                                </div>
                            </div>
                            <div id="toast-error-quoteService" class="toast toast-error" role="alert"
                                aria-live="assertive" aria-atomic="true">
                                <div class="toast-content">
                                    <i class="toast-icon fas fa-exclamation-circle"></i>
                                    <div class="toast-message"></div>
                                </div>
                            </div>
                        </div>
                        <center>
                            <div class="g-recaptcha" id="formRecatpcha"></div>
                        </center>
                        <input type="checkbox" name="checkbox" id="checkbox" required>
                        <label for="checkbox">
                            By submitting your information you provide written consent to knothost and its family of
                            brands contacting you.
                        </label>
                        <button type="submit" class="submit__btn" name="submit__btn">Get a Quote</button>
                    </form>
                </div>
            </div>
        </div>
    </div>
</section>
<!-- End Get a Quote for Logo Design -->


<!-- LOGO DESIGN FAQ -->
<div class="rts-hosting-faq section__padding">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-lg-8">
                <div class="rts-section text-center">
                    <h2 class="rts-section__title mb-0" data-sal="slide-down" data-sal-delay="100"
                        data-sal-duration="800">Frequently Asked Questions</h2>
                </div>
                <div class="rts-faq__accordion">
                    <div class="accordion accordion-flush" id="rts-accordion">
                        <div class="accordion-item active">
                            <div class="accordion-header" id="first">
                                <h4 class="accordion-button collapse show" data-bs-toggle="collapse"
                                    data-bs-target="#item__one" aria-expanded="false" aria-controls="item__one">
                                    Why choose KnotHost for your logo design needs?
                                </h4>
                            </div>
                            <div id="item__one" class="accordion-collapse collapse collapse show"
                                aria-labelledby="first" data-bs-parent="#rts-accordion">
                                <div class="accordion-body">
                                    At KnotHost, we understand the importance of a captivating logo for your brand. Our
                                    team is dedicated to crafting unique and memorable designs that resonate with your
                                    audience.
                                </div>
                            </div>
                        </div>
                        <div class="accordion-item">
                            <div class="accordion-header" id="two">
                                <h4 class="accordion-button collapsed" data-bs-toggle="collapse"
                                    data-bs-target="#item__two" aria-expanded="false" aria-controls="item__two">
                                    How does the logo design process work?
                                </h4>
                            </div>
                            <div id="item__two" class="accordion-collapse collapse" aria-labelledby="two"
                                data-bs-parent="#rts-accordion">
                                <div class="accordion-body">
                                    Our logo design process begins with a deep understanding of your brand identity and
                                    target audience. We collaborate closely with you to create concepts that reflect
                                    your vision and values.
                                </div>
                            </div>
                        </div>
                        <div class="accordion-item">
                            <div class="accordion-header" id="three">
                                <h4 class="accordion-button collapsed" data-bs-toggle="collapse"
                                    data-bs-target="#item__three" aria-expanded="false" aria-controls="item__three">
                                    Why is a professionally designed logo important?
                                </h4>
                            </div>
                            <div id="item__three" class="accordion-collapse collapse" aria-labelledby="three"
                                data-bs-parent="#rts-accordion">
                                <div class="accordion-body">
                                    A professionally designed logo serves as the visual representation of your brand. It
                                    communicates credibility, professionalism, and establishes a strong identity in the
                                    market.
                                </div>
                            </div>
                        </div>

                        <div class="accordion-item">
                            <div class="accordion-header" id="four">
                                <h4 class="accordion-button collapsed" data-bs-toggle="collapse"
                                    data-bs-target="#item__four" aria-expanded="false" aria-controls="item__four">
                                    How can KnotHost help me with my logo design journey?
                                </h4>
                            </div>
                            <div id="item__four" class="accordion-collapse collapse" aria-labelledby="four"
                                data-bs-parent="#rts-accordion">
                                <div class="accordion-body">
                                    We're here to guide you through every step of the logo design process. From
                                    conceptualization to finalization, our expert team ensures that your vision is
                                    brought to life in the most impactful way possible.
                                </div>
                            </div>
                        </div>
                        <div class="accordion-item">
                            <div class="accordion-header" id="five">
                                <h4 class="accordion-button collapsed" data-bs-toggle="collapse"
                                    data-bs-target="#item__five" aria-expanded="false" aria-controls="item__four">
                                    What sets KnotHost apart in the realm of logo design?
                                </h4>
                            </div>
                            <div id="item__five" class="accordion-collapse collapse" aria-labelledby="five"
                                data-bs-parent="#rts-accordion">
                                <div class="accordion-body">
                                    At KnotHost, we combine creativity with strategy to deliver logos that not only look
                                    great but also align with your brand's goals and objectives. Your success is our
                                    priority, and we go above and beyond to exceed your expectations.
                                </div>
                            </div>
                        </div>

                    </div>
                </div>
            </div>

        </div>
    </div>
</div>
<!-- LOGO DESIGN FAQ END -->

<!-- knothost CTA -->
<div class="rts-cta-two shared-page-bg">
    <div class="container">
        <div class="row">
            <div class="rts-cta-two__wrapper">
                <div class="cta__shape"></div>
                <div class="cta-content">
                    <span data-sal="slide-down" data-sal-delay="100" data-sal-duration="800">Ready to get a quote for
                        your logo design?</span>
                    <h4 data-sal="slide-down" data-sal-delay="200" data-sal-duration="800">We're here to assist you with
                        your logo needs.</h4>
                </div>

                <div class="cta-btn">
                    <a href="tel:+971585408365" class="contact__us rts-btn rts-btn-secondary" data-sal="slide-left"
                        data-sal-delay="100" data-sal-duration="800">Contact Us</a>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- knothost CTA END -->

<script>
    document.getElementById('quoteServiceform').addEventListener('submit', function (event) {
        event.preventDefault();

        const button = document.querySelector(".rts-contact-form .form__content .submit__btn")
        const backupHTML = button.innerHTML;

        button.innerHTML = "<i class='fa-regular fa-spinner animate-spin'></i>"

        const formData = new FormData(this);

        const formObject = {};
        formData.forEach((value, key) => {
            formObject[key] = value;
        });

        fetch('quoteService.php', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json'
            },
            body: JSON.stringify(formObject)
        })
            .then(response => response.json())
            .then(data => {
                console.log({
                    data
                });
                if (data.status === 'success') {
                    showToast('Quote request sent successfully!', 'success', 'quoteService');
                } else {
                    showToast('Oops Something went wrong! Please contact us through info@knothost.com', 'error', 'quoteService');
                }
            })
            .catch(error => {
                showToast('Oops Something went wrong! Please contact us through info@knothost.com', 'error', 'quoteService');
            })
            .finally(() => {
                grecaptcha.reset(formRecatpcha);
                button.innerHTML = backupHTML;
            });
    });
</script>


<?php include ("layout/footer.php") ?>