<?php
header('Content-Type: application/json');

$servername = "localhost";
$username = "sonuaeldosimon_knothost";
$password = "P07u3Jl,H}Ep";
$dbname = "sonuaeldosimon_knothost_subscription";

$response = array();


try {
    $conn = new mysqli($servername, $username, $password, $dbname);

    if ($conn->connect_error) {
        error_log("Connection failed: " . $conn->connect_error);

        $response['status'] = 'error';
        $response['message'] = 'Failed to connect to the database';
    } else {
        $data = json_decode(file_get_contents('php://input'), true);

        if ($_SERVER["REQUEST_METHOD"] == "POST") {
            if (!isset($data['g-recaptcha-response']) || !isset($data['email'])) {
                throw new Exception("Missing required fields.");
            }

            $recaptcha_secret = "6LdQE6EdAAAAAPIUZVUWi9o84OTXu7DZD9KDtqyL";
            $recaptcha_response = $data['g-recaptcha-response'];
            $url = 'https://www.google.com/recaptcha/api/siteverify';
            $data_recaptcha = array(
                'secret' => $recaptcha_secret,
                'response' => $recaptcha_response
            );
            $options = array(
                'http' => array(
                    'header' => "Content-Type: application/x-www-form-urlencoded\r\n",
                    'method' => 'POST',
                    'content' => http_build_query($data_recaptcha)
                )
            );
            $context = stream_context_create($options);
            $result = file_get_contents($url, false, $context);
            $responseCaptcha = json_decode($result);

            if ($responseCaptcha->success) {
                $email = $data['email'];
                if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
                    $response['status'] = 'error';
                    $response['message'] = 'Invalid email format';
                } else {
                    $stmt = $conn->prepare("INSERT INTO newsletter_subscribers (email) VALUES (?)");
                    if (!$stmt) {
                        throw new Exception("Prepare statement failed: " . $conn->error);
                    }
                    $stmt->bind_param("s", $email);

                    if ($stmt->execute()) {
                        $response['status'] = 'success';
                        $response['message'] = 'Thank you for subscribing!';
                    } else {
                        throw new Exception("Execute statement failed: " . $stmt->error);
                    }

                    $stmt->close();
                }
            } else {
                $response['status'] = 'error';
                $response['message'] = 'reCAPTCHA verification failed';
            }
        }
    }
} catch (Exception $e) {
    error_log($e->getMessage());

    $response['status'] = 'error';
    if (strpos($e->getMessage(), 'Execute statement failed: Duplicate entry') !== false) {
        $response['message'] = 'Already subscribed!';
    } else {
        $response['message'] = 'Oops Something went wrong! Please contact us through info@knothost.com';
    }
}

if (isset($conn) && $conn instanceof mysqli) {
    $conn->close();
}

echo json_encode($response);
?>