<?php
header('Content-Type: application/json');

require __DIR__ . '/phpmailer/src/Exception.php';
require __DIR__ . '/phpmailer/src/PHPMailer.php';
require __DIR__ . '/phpmailer/src/SMTP.php';

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;
use PHPMailer\PHPMailer\SMTP;

$mail = new PHPMailer(true);


function sendEmail($to, $subject, $body)
{
    global $mail;

    try {
        // $mail->SMTPDebug = SMTP::DEBUG_SERVER;
        // $mail->isSMTP();
        $mail->Host = 'mail.knothost.com';
        $mail->SMTPAuth = true;
        $mail->Username = 'website-form@knothost.com';
        $mail->Password = "edhWe&]G9_rM";
        $mail->SMTPSecure = PHPMailer::ENCRYPTION_SMTPS;
        $mail->Port = 465;

        $mail->setFrom('website-form@knothost.com', 'Mailer');
        $mail->addAddress($to);

        $mail->isHTML(true);
        $mail->Subject = $subject;
        $mail->Body = $body;

        $mail->send();
        return true;
    } catch (Exception $e) {
        // error_log('Email sending failed: ' . $e->getMessage());
        return false;
    }
}

$response = array();

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $requestBody = file_get_contents('php://input');
    $formData = json_decode($requestBody, true);

    if (!isset($formData['g-recaptcha-response']) || empty($formData['g-recaptcha-response'])) {
        $response['status'] = 'error';
        $response['message'] = 'reCAPTCHA verification failed. captcha not included in the request';
    } else {
        $recaptcha_secret = "6LdQE6EdAAAAAPIUZVUWi9o84OTXu7DZD9KDtqyL";
        $recaptcha_response = $formData['g-recaptcha-response'];
        $url = 'https://www.google.com/recaptcha/api/siteverify';
        $data = array(
            'secret' => $recaptcha_secret,
            'response' => $recaptcha_response
        );

        try {
            $options = array(
                'http' => array(
                    'header' => "Content-Type: application/x-www-form-urlencoded\r\n",
                    'method' => 'POST',
                    'content' => http_build_query($data)
                )
            );
            $context = stream_context_create($options);
            $result = file_get_contents($url, false, $context);
            $responseCaptcha = json_decode($result);

            if ($responseCaptcha->success) {
                $name = $formData['name'];
                $email = $formData['email'];
                $phone = $formData['phone'];
                $budget = $formData['budget'];
                $message = $formData['message'];

                $to = 'info@knothost.com';
                $subject = 'New Quote Request';
                $body = "<p>Name: $name</p>";
                $body .= "<p>Email: $email</p>";
                $body .= "<p>Phone: $phone</p>";
                $body .= "<p>Budget: $budget</p>";
                $body .= "<p>Message: $message</p>";

                $mail_sent = sendEmail($to, $subject, $body);

                if ($mail_sent) {
                    $response['status'] = 'success';
                    $response['message'] = 'Quote request submitted successfully.';
                } else {
                    $response['status'] = 'error';
                    $response['message'] = 'Failed to send email.';
                }
            } else {
                $response['status'] = 'error';
                $response['message'] = 'reCAPTCHA verification failed.';
            }
        } catch (Exception $e) {
            $response['status'] = 'error';
            $response['message'] = $e->getMessage();
            error_log($e->getMessage());
        }
    }
} else {
    $response['status'] = 'error';
    $response['message'] = 'Invalid request method.';
}

echo json_encode($response);
?>