<?php
require_once("core/data.php");

$current_path = parse_url($_SERVER['REQUEST_URI'], PHP_URL_PATH);

$current_page;

if ($current_path === '/' || $current_path === '/index.php' || $current_path === "index.php" || $current_path === "") {
    $current_page = 'home';
} else {
    $current_page = basename($current_path, '.php');
}

$current_seo = $seo_content[$current_page] ?? $seo_content['home'];

if ($current_page === 'service-details') {
    $service_key = $_GET['service'] ?? '';
    $current_seo = $services_data[$service_key]['seo'] ?? $current_seo;
}
?>

<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="shortcut icon" type="image/x-icon" href="assets/images/favicon.ico">

    <!-- SEO Meta Tags -->
    <title><?php echo htmlspecialchars($current_seo['title']); ?></title>
    <meta name="description" content="<?php echo htmlspecialchars($current_seo['description']); ?>">
    <meta name="keywords" content="<?php echo htmlspecialchars($current_seo['keywords']); ?>">

    <!-- Additional SEO Meta Tags -->
    <meta name="author" content="Novosafe">
    <meta name="robots" content="index, follow">
    <link rel="canonical" href="https://pumprepairuae.com/<?php echo htmlspecialchars($current_page); ?>">

    <!-- Open Graph Meta Tags for social media -->
    <meta property="og:title" content="<?php echo htmlspecialchars($current_seo['title']); ?>">
    <meta property="og:description" content="<?php echo htmlspecialchars($current_seo['description']); ?>">
    <meta property="og:image" content="https://pumprepairuae.com/assets/images/logo/logo-01.svg">
    <meta property="og:url" content="https://pumprepairuae.com/">
    <meta property="og:type" content="website">

    <!-- Twitter Card Meta Tags -->
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="<?php echo htmlspecialchars($current_seo['title']); ?>">
    <meta name="twitter:description" content="<?php echo htmlspecialchars($current_seo['description']); ?>">
    <meta name="twitter:image" content="https://pumprepairuae.com/assets/images/logo/novosafe_logo_nobg.png">

    <!-- Schema Markup for Local Business -->
    <script type="application/ld+json">
{
  "@context": "https://schema.org",
  "@type": "LocalBusiness",
  "name": "Novosafe Pump Services",
  "url": "https://pumprepairuae.com",
  "telephone": "<?php echo $phone ?>",
  "address": {
    "@type": "PostalAddress",
    "streetAddress": "Shaibani building",
    "addressLocality": "Dubai",
    "addressRegion": "UAE",
    "postalCode": "00000",
    "addressCountry": "AE"
  },
  "description": "Leading provider of pump and generator services in Dubai."
}
</script>

    <script src="https://www.google.com/recaptcha/api.js" async defer></script>

    <!-- CSS links here -->
    <link rel="stylesheet" href="assets/css/plugins/fontawesome-6.css">
    <link rel="stylesheet" href="assets/css/plugins/swiper.css">
    <link rel="stylesheet" href="assets/css/plugins/unicons.css">
    <link rel="stylesheet" href="assets/css/plugins/metismenu.css">
    <link rel="stylesheet" href="assets/css/vendor/animate.css">
    <link rel="stylesheet" href="assets/css/vendor/bootstrap.min.css">
    <link rel="stylesheet" type="text/css" href="assets/css/vendor/phosphor/phosphor.min.css">
    <link rel="stylesheet" href="assets/css/style.css">
    <script>
        console.log({ "current_page": "<?php echo $current_page ?>", "current_path": "<?php echo $curreng_path ?>" })
    </script>
</head>

<body class="index-shop">

    <div class="toast-container">
        <div class="toast"></div>
    </div>

    <!-- header style two -->
    <div class="header-header-two">
        <!-- header- solaric two -->
        <div class="header-two-solari header-top">
            <div class="container">
                <div class="row">
                    <div class="col-lg-12">
                        <div class="header-top-m">
                            <div class="left">
                                <div class="inf">
                                    <i class="fa-regular fa-clock"></i>
                                    <p>Mon - Fri 8:00 - 18:00 / Sunday 8:00 - 14:00</p>
                                </div>
                                <div class="inf">
                                    <i class="fa-regular fa-phone"></i>
                                    <a href="tel:<?php echo ($phone) ?>"><?php echo ($phone) ?></a>
                                </div>
                                <div class="inf">
                                    <i class="fa-regular fa-envelope"></i>
                                    <a href="mailto:<?php echo ($email) ?>"><?php echo ($email) ?></a>
                                </div>
                            </div>
                            <div class="right">
                                <div class="social-header-top-h2">
                                    <span>Visit Us:</span>
                                    <ul>
                                        <li><a href="#"><i class="fa-brands fa-facebook-f"></i></a></li>
                                        <li><a href="#"><i class="fa-brands fa-twitter"></i></a></li>
                                        <li><a href="#"><i class="fa-brands fa-linkedin-in"></i></a></li>
                                        <li><a href="#"><i class="fa-brands fa-instagram"></i></a></li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- header- solaric two end -->
        <!-- header man start -->
        <div class="header-main-h2  header--sticky">
            <div class="container">
                <div class="row">
                    <div class="col-lg-12">
                        <div class="main-haeder-wrapper-h2">
                            <a href="index.php" class="logo-area">
                                <img src="assets/images/logo/novosafe_pump_logo.jpg" alt="logo" width="157px" height="50px">
                            </a>

                            <!-- navigation area start -->
                            <div class="header-nav main-nav-one">
                                <nav>
                                    <ul>
                                        <li class="<?= $current_page === 'home' ? 'active' : '' ?>">
                                            <a class="nav-link" href="index.php">HOME</a>
                                        </li>
                                        <li class="<?= $current_page === 'about' ? 'active' : '' ?>">
                                            <a class="nav-link" href="aboutus.php">ABOUT US</a>
                                        </li>
                                        <li class="<?= $current_page === 'about' ? 'active' : '' ?>">
                                            <a class="nav-link" href="trading.php">TRADING</a>
                                        </li>
                                        <li
                                            class="<?= $current_page === 'service' ? 'active has-dropdown' : 'has-dropdown' ?>">
                                            <a class="nav-link" href="service.php">SERVICES</a>
                                            <ul class="submenu">
                                                <li><a href="service.php#generator-service" class="tag">Generator
                                                        Services</a></li>
                                                <li><a href="service.php#pressure-vessels" class="tag">Pressure
                                                        Vessels</a></li>
                                                <li><a href="service.php#water-pump" class="tag">Water Pump</a></li>
                                                <li><a href="service.php#transfer-pumpset" class="tag">Transfer
                                                        Pumpset</a></li>
                                                <li><a href="service.php#full-inspection" class="tag">Full
                                                        Inspection</a></li>
                                            </ul>
                                        </li>

                                        <li class="<?= $current_page === 'contact' ? 'active' : '' ?>">
                                            <a class="nav-link" href="contact.php">CONTACT</a>
                                        </li>
                                    </ul>
                                </nav>
                            </div>
                            <!-- navigation area end -->
                            <div class="actions-area">
                                <div class="menu-btn" id="menu-btn">
                                    <svg width="20" height="16" viewBox="0 0 20 16" fill="none"
                                        xmlns="http://www.w3.org/2000/svg">
                                        <rect y="14" width="20" height="2" fill="#06add9" />
                                        <rect y="7" width="20" height="2" fill="#06add9" />
                                        <rect width="20" height="2" fill="#06add9" />
                                    </svg>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- header man end -->
    </div>

    <!-- mobile menu area start -->
    <div id="side-bar" class="side-bar header-two">
        <?php include "components/mobileMenu.php" ?>
    </div>
    <!-- header style two End -->