<?php require("components/header.php");
require("core/data.php"); ?>


<!-- banner area start -->
<div class="banner-shop-area bg_image rts-section-gap">
    <div class="container">
        <div class="row">
            <div class="col-lg-12">
                <div class="banner-shop-content-wrapper">
                    <span class="pre">Reliable Maintenance for Peak Performance</span>
                    <h1 class="title">
                        <div>Pump & Generator<div>
                                <span class="draw">
                                    Solutions
                                    <svg width="157" height="18" viewBox="0 0 157 18" fill="none"
                                        xmlns="http://www.w3.org/2000/svg">
                                        <path class="wow" d="M1 16.569C35.3333 3.73568 107.7 -4.03506 156.5 7.96494"
                                            stroke="#06add9" stroke-width="3" />
                                    </svg>
                                </span> <br>
                                <span class="ita d-block">Novosafe Pump Services</span>
                    </h1>
                    <p class="disc wp hero-desc"> Novosafe Pump Services, your trusted partner in expert
                        maintenance solutions for pumps and generators across Dubai and beyond.</p>
                    <a href="service.php" class="rts-btn btn-primary">Discover Our Services</a>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- banner area end -->

<!-- latest lews updates start -->
<div class="blog-area-style-four rts-section-gap mt-dec-30 bg-about-h4">
    <div class="container">
        <div class="row">
            <div class="col-lg-12">
                <div class="solari-title-area-three text-center">
                    <span class="pre-title skew-up">Best in Class Services</span>
                    <h2 class="title skew-up">Expert Services for Pumps and Generators in Dubai</h2>
                    <p class="disc skew-up">
                        At Novosafe Pump Services LLC, we are dedicated to enhancing the reliability and efficiency of
                        your pumps and generators. Our specialized services include maintenance, overhauling, and Annual
                        Maintenance Contracts (AMC) for pumps and generators across Dubai and the UAE.
                    </p>
                </div>


            </div>
        </div>
        <div class="row g-5 mt--30">
            <?php include("components/serviceCard.php") ?>
        </div>
    </div>
    <!-- latest lews updates end -->

    <!-- about area start -->
    <div class="rts-about-area-start-h3-soalri rts-section-gap bg-lighten">
        <div class="bottom-left-img images">
            <img src="assets/images/about/27.png" alt="novosafe about us image">
        </div>
        <div class="container">
            <div class="row g-5 align-items-center">
                <div class="col-lg-6">
                    <!-- about left area start -->
                    <div class="about-lefta-area-solari-2 pb--150">
                        <div class="thumbnail-image-lg">
                            <img src="assets/images/novosafe/19.jpg" class="rounded-img"
                                alt="novosafe about us thumbnail">
                        </div>
                        <div class="thumbnail-image-bottom images-2">
                            <img src="assets/images/novosafe/26.jpg" class="rounded-img"
                                alt="novosafe about us thumbnail">

                        </div>

                    </div>
                    <!-- about left area end -->
                </div>
                <div class="col-lg-6 pl--110 pl_sm--15 padding-reset-sm  pl_md--15">
                    <div class="about-area-solari-3-right">
                        <div class="solari-title-area-three">
                            <span class="pre-title skew-up">About Us</span>
                            <h2 class="title skew-up">Specialists in Pump Services and Generator Maintenance in Dubai
                            </h2>
                        </div>
                        <div class="inner-content">
                            <p class="disc">
                                At Novosafe Pump Services LLC, we specialize in providing comprehensive pump services
                                and generator maintenance in Dubai, including Annual Maintenance Contracts (AMC). Our
                                expertise covers pump overhauling, machining works, and preventative maintenance,
                                ensuring optimal performance and efficiency for industries across Dubai and the UAE.
                            </p>

                            <div class="importanc-wrapper">
                                <div class="single">
                                    <div class="icon">
                                        <svg width="55" height="55" viewBox="0 0 55 55" fill="none"
                                            xmlns="http://www.w3.org/2000/svg">
                                            <path
                                                d="M23.8916 52.4916H21.7666V50.9083C21.7666 50.2666 21.2416 49.7416 20.6 49.7416H19.4833V47.2999H28.525C28.9583 47.2999 29.3583 47.0833 29.5916 46.7166C29.825 46.35 29.8583 45.9 29.6833 45.5083L25.1 35.3249C24.9 34.8749 24.4416 34.575 23.9416 34.575H6.8833C6.3833 34.575 5.9333 34.8666 5.72497 35.3249L1.14164 45.5083C0.966637 45.9 0.99997 46.35 1.2333 46.7166C1.46664 47.0833 1.86664 47.2999 2.29997 47.2999H11.3416V49.7416H10.225C9.5833 49.7416 9.0583 50.2666 9.0583 50.9083V52.4916H6.94164C6.6083 52.4916 6.3333 52.7666 6.3333 53.1C6.3333 53.4333 6.6083 53.7083 6.94164 53.7083H23.8916C24.225 53.7083 24.5 53.4333 24.5 53.1C24.5 52.7666 24.2333 52.4916 23.8916 52.4916ZM28.5833 46.0083L28.5333 46.0833H23L22.4166 43.4916H27.4583L28.5833 46.0083ZM26.9083 42.2749H22.1416L21.5333 39.5916H25.7L26.9083 42.2749ZM23.95 35.7916C23.975 35.7916 23.9916 35.8083 24 35.825L25.15 38.3833H21.2583L20.675 35.7916H23.95ZM16.025 35.7916H19.4333L20.0166 38.3833H16.025V35.7916ZM16.025 39.5999H20.2916L20.9 42.2833H16.0333V39.5999H16.025ZM16.025 43.4916H21.1666L21.75 46.0833H16.0166V43.4916H16.025ZM18.275 47.2999V49.7416H12.5583V47.2999H18.275ZM11.4083 35.7916H14.8166V38.3833H10.825L11.4083 35.7916ZM14.8083 39.5999V42.2833H9.94164L10.55 39.5999H14.8083ZM6.8833 35.7916H10.1583L9.57497 38.3833H5.7083L6.8833 35.7916ZM7.84164 46.0833H2.29997L2.24997 46.0083L3.39164 43.4916H8.42497L7.84164 46.0833ZM3.94164 42.2749L5.1583 39.5916H9.29997L8.69164 42.2749H3.94164ZM9.0833 46.0833L9.66664 43.4916H14.8083V46.0833H9.0833ZM20.5583 52.4916H10.2666L10.2333 50.9499L20.5583 50.9083V52.4916Z"
                                                fill="#06add9" />
                                            <path
                                                d="M51.1665 24.3167C50.8331 23.4501 50.0748 22.8417 49.1831 22.7167L40.6415 21.4334C40.6498 21.3417 40.6665 21.2501 40.6665 21.1584C40.6665 19.3834 39.5831 17.8584 38.0498 17.2084V2.33339C38.0498 1.88339 37.7831 1.50006 37.3581 1.35839C36.9415 1.20839 36.4998 1.34173 36.2248 1.68339L31.7581 7.20006C31.1915 7.90839 31.0331 8.86673 31.3665 9.72506L34.3915 17.3917C33.0331 18.1167 32.0915 19.5251 32.0915 21.1667C32.0915 21.4917 32.1331 21.8001 32.1998 22.1001L19.2831 29.5584C18.8998 29.7751 18.7081 30.2001 18.7831 30.6334C18.8665 31.0667 19.1998 31.3917 19.6331 31.4584L26.6415 32.5667C26.7665 32.5834 26.8998 32.5917 27.0248 32.5917C27.7915 32.5917 28.5331 32.2417 29.0165 31.6334L34.3581 24.9167C34.9665 25.2417 35.6498 25.4501 36.3831 25.4501C37.3665 25.4501 38.2581 25.1084 38.9831 24.5501L52.2415 32.1917C52.4081 32.2834 52.5831 32.3334 52.7581 32.3334C52.9998 32.3334 53.2331 32.2501 53.4331 32.0751C53.7665 31.7834 53.8748 31.3417 53.7165 30.9417L51.1665 24.3167ZM32.4915 9.27506C32.3248 8.83339 32.3998 8.32506 32.6998 7.95839L36.8331 2.85006V16.9167C36.6831 16.9001 36.5331 16.8667 36.3831 16.8667C36.0915 16.8667 35.7998 16.9001 35.5248 16.9501L32.4915 9.27506ZM28.0665 30.8834C27.7665 31.2584 27.3081 31.4417 26.8331 31.3667L20.3498 30.3417L32.6498 23.2334C32.8498 23.5917 33.0831 23.9251 33.3748 24.2084L28.0665 30.8834ZM36.3831 24.2334C34.6831 24.2334 33.3081 22.8501 33.3081 21.1584C33.3081 19.4584 34.6915 18.0834 36.3831 18.0834C38.0748 18.0834 39.4581 19.4667 39.4581 21.1584C39.4581 22.8584 38.0748 24.2334 36.3831 24.2334ZM39.8581 23.6501C40.0831 23.3417 40.2581 22.9917 40.3915 22.6251L49.0081 23.9167C49.4665 23.9751 49.8581 24.3001 50.0248 24.7501L52.3831 30.8751L39.8581 23.6501Z"
                                                fill="#06add9" />
                                            <path
                                                d="M44.1752 52.4917H42.5335L39.0002 26.8334C38.9585 26.5001 38.6502 26.2751 38.3169 26.3167C37.9835 26.3584 37.7502 26.6667 37.8002 27.0001L38.9002 34.9751H36.9085C36.5752 34.9751 36.3002 35.2501 36.3002 35.5834C36.3002 35.9167 36.5752 36.1917 36.9085 36.1917H39.0669L40.7002 48.0501H37.0919C36.7585 48.0501 36.4835 48.3251 36.4835 48.6584C36.4835 48.9917 36.7585 49.2667 37.0919 49.2667H40.8669L41.3085 52.4917H31.5919L32.8752 43.1501H36.3585C36.6919 43.1501 36.9669 42.8751 36.9669 42.5417C36.9669 42.2084 36.6919 41.9334 36.3585 41.9334H33.0419L35.0919 27.0501C35.1335 26.7167 34.9085 26.4084 34.5752 26.3667C34.2335 26.3251 33.9335 26.5501 33.8919 26.8834L30.3669 52.4917H28.8085C28.4752 52.4917 28.2002 52.7667 28.2002 53.1001C28.2002 53.4334 28.4752 53.7084 28.8085 53.7084H44.1669C44.5002 53.7084 44.7752 53.4334 44.7752 53.1001C44.7752 52.7667 44.5085 52.4917 44.1752 52.4917Z"
                                                fill="#06add9" />
                                            <path
                                                d="M20.25 13.9418C20.5833 13.9418 20.8583 13.6668 20.8583 13.3334C20.8583 11.6668 22.2166 10.3084 23.8833 10.3084C25.55 10.3084 26.9 11.6668 26.9 13.3334C26.9 15.0001 25.55 16.3501 23.8833 16.3501H10.2416C9.9083 16.3501 9.6333 16.6251 9.6333 16.9584C9.6333 17.2918 9.9083 17.5668 10.2416 17.5668H23.8833C26.2166 17.5668 28.1166 15.6668 28.1166 13.3334C28.1166 11.0001 26.2166 9.1001 23.8833 9.1001C21.55 9.1001 19.65 11.0001 19.65 13.3334C19.6416 13.6751 19.9083 13.9418 20.25 13.9418Z"
                                                fill="#06add9" />
                                            <path
                                                d="M3.01654 11.9166H13.4165C15.7499 11.9166 17.6499 10.0166 17.6499 7.68329C17.6499 5.34995 15.7499 3.44995 13.4165 3.44995C11.0832 3.44995 9.1832 5.34995 9.1832 7.68329C9.1832 8.01662 9.4582 8.29162 9.79154 8.29162C10.1249 8.29162 10.3999 8.01662 10.3999 7.68329C10.3999 6.01662 11.7582 4.65828 13.4249 4.65828C15.0915 4.65828 16.4415 6.01662 16.4415 7.68329C16.4415 9.34995 15.0915 10.7 13.4249 10.7H3.01654C2.6832 10.7 2.4082 10.975 2.4082 11.3083C2.41654 11.6416 2.6832 11.9166 3.01654 11.9166Z"
                                                fill="#06add9" />
                                            <path
                                                d="M42.3998 11.9167H50.2165C52.2832 11.9167 53.9582 10.2417 53.9582 8.17505C53.9582 6.10838 52.2832 4.42505 50.2165 4.42505C48.1498 4.42505 46.4665 6.10838 46.4665 8.17505C46.4665 8.50838 46.7415 8.78338 47.0748 8.78338C47.4082 8.78338 47.6832 8.50838 47.6832 8.17505C47.6832 6.77505 48.8165 5.64172 50.2165 5.64172C51.6082 5.64172 52.7415 6.77505 52.7415 8.17505C52.7415 9.56672 51.6082 10.7 50.2165 10.7H42.3998C42.0665 10.7 41.7915 10.975 41.7915 11.3084C41.7998 11.6417 42.0665 11.9167 42.3998 11.9167Z"
                                                fill="#06add9" />
                                            <path
                                                d="M42.0082 16.3251H50.4166C50.7499 16.3251 51.0249 16.0501 51.0249 15.7167C51.0249 15.3834 50.7499 15.1084 50.4166 15.1084H42.0082C41.6749 15.1084 41.3999 15.3834 41.3999 15.7167C41.3999 16.0501 41.6666 16.3251 42.0082 16.3251Z"
                                                fill="#06add9" />
                                            <path
                                                d="M4.73333 20.55C4.4 20.55 4.125 20.825 4.125 21.1584C4.125 21.4917 4.4 21.7667 4.73333 21.7667H16.125C16.4583 21.7667 16.7333 21.4917 16.7333 21.1584C16.7333 20.825 16.4583 20.55 16.125 20.55H4.73333Z"
                                                fill="#06add9" />
                                        </svg>
                                    </div>
                                    <div class="info">
                                        <h6 class="title">1,000+</h6>
                                        <p>Pumps and Generators Serviced</p>
                                    </div>
                                </div>
                                <div class="single">
                                    <div class="icon">

                                        <svg width="55" height="55" viewBox="0 0 55 55" fill="none"
                                            xmlns="http://www.w3.org/2000/svg">
                                            <g clip-path="url(#clip0_49_535)">
                                                <path
                                                    d="M51.2801 29.5011C50.9182 29.1392 50.4886 28.852 50.0157 28.6561C49.5428 28.4602 49.0359 28.3594 48.5241 28.3594C48.0122 28.3594 47.5054 28.4602 47.0325 28.6561C46.5596 28.852 46.1299 29.1392 45.768 29.5011L39.0962 36.173C38.8035 35.6311 38.3702 35.1782 37.8418 34.8618C37.3135 34.5454 36.7096 34.3772 36.0938 34.375H26.3343C25.4942 33.3581 24.4508 32.528 23.2711 31.9379C22.0914 31.3478 20.8015 31.0106 19.4839 30.9481C18.1664 30.8856 16.8503 31.099 15.62 31.5747C14.3897 32.0505 13.2724 32.778 12.3397 33.7107L8.59378 37.4567L7.48261 36.3455C7.40283 36.2657 7.30811 36.2024 7.20385 36.1592C7.0996 36.116 6.98785 36.0938 6.875 36.0938C6.76215 36.0938 6.65041 36.116 6.54615 36.1592C6.4419 36.2024 6.34718 36.2657 6.2674 36.3455L2.8299 39.783C2.75008 39.8628 2.68676 39.9575 2.64356 40.0618C2.60036 40.1661 2.57813 40.2778 2.57812 40.3907C2.57813 40.5035 2.60036 40.6152 2.64356 40.7195C2.68676 40.8238 2.75008 40.9185 2.8299 40.9983L16.5799 54.7483C16.6597 54.8281 16.7544 54.8914 16.8587 54.9346C16.9629 54.9778 17.0747 55 17.1875 55C17.3004 55 17.4121 54.9778 17.5164 54.9346C17.6206 54.8914 17.7153 54.8281 17.7951 54.7483L21.2326 51.3108C21.3124 51.231 21.3757 51.1363 21.4189 51.032C21.4621 50.9277 21.4844 50.816 21.4844 50.7032C21.4844 50.5903 21.4621 50.4786 21.4189 50.3743C21.3757 50.27 21.3124 50.1753 21.2326 50.0955L20.1215 48.9844L21.0853 48.0205C21.57 47.5389 22.2249 47.2677 22.9082 47.2656H35.4682C36.5972 47.2688 37.7157 47.0479 38.7588 46.6158C39.8019 46.1837 40.7489 45.549 41.545 44.7483L51.2801 35.0132C51.6421 34.6513 51.9293 34.2217 52.1252 33.7488C52.3211 33.2759 52.4219 32.7691 52.4219 32.2572C52.4219 31.7453 52.3211 31.2385 52.1252 30.7656C51.9293 30.2927 51.6421 29.863 51.2801 29.5011ZM17.1875 52.9254L4.65274 40.3906L6.87503 38.1683L19.4098 50.7031L17.1875 52.9254ZM50.0649 33.798L40.3298 43.5331C39.6928 44.1736 38.9352 44.6813 38.1007 45.027C37.2662 45.3726 36.3714 45.5493 35.4682 45.5469H22.9082C22.3437 45.5453 21.7846 45.6558 21.2631 45.8718C20.7416 46.0878 20.2682 46.4051 19.8701 46.8053L18.9063 47.7692L9.80899 38.6719L13.5549 34.926C14.3283 34.1527 15.2566 33.5518 16.2788 33.1629C17.3009 32.7739 18.3938 32.6058 19.4856 32.6694C20.5774 32.733 21.6434 33.027 22.6135 33.532C23.5836 34.037 24.4358 34.7416 25.1141 35.5994L25.2463 35.7669C25.3267 35.8688 25.4291 35.9511 25.5459 36.0077C25.6627 36.0644 25.7908 36.0938 25.9206 36.0938H36.0938C36.5496 36.0938 36.9868 36.2748 37.3091 36.5972C37.6314 36.9195 37.8125 37.3567 37.8125 37.8125C37.8125 38.2683 37.6314 38.7055 37.3091 39.0278C36.9868 39.3502 36.5496 39.5312 36.0938 39.5312H24.0625C23.8346 39.5312 23.616 39.6218 23.4549 39.783C23.2937 39.9441 23.2032 40.1627 23.2032 40.3906C23.2032 40.6185 23.2937 40.8371 23.4549 40.9983C23.616 41.1595 23.8346 41.25 24.0625 41.25H36.0938C36.9344 41.2474 37.7448 40.9361 38.3711 40.3754C38.9974 39.8147 39.396 39.0436 39.4913 38.2084L46.9833 30.7163C47.3984 30.32 47.9502 30.0989 48.5241 30.0989C49.098 30.0989 49.6499 30.32 50.0649 30.7163C50.2673 30.9187 50.4278 31.1589 50.5373 31.4233C50.6468 31.6876 50.7032 31.971 50.7032 32.2572C50.7032 32.5433 50.6468 32.8267 50.5373 33.091C50.4278 33.3554 50.2673 33.5957 50.0649 33.798Z"
                                                    fill="#06add9" />
                                                <path
                                                    d="M16.9675 17.512C16.9555 17.5288 16.9374 17.5383 16.9265 17.5562C16.9237 17.5609 16.9239 17.5663 16.9211 17.571C14.3074 20.8906 12.8877 24.9936 12.8906 29.2186C12.8906 29.3592 12.8915 29.4989 12.9011 29.6391C12.9162 29.856 13.013 30.0591 13.1719 30.2076C13.3308 30.356 13.5401 30.4386 13.7576 30.4389C13.7777 30.4389 13.7978 30.438 13.818 30.4368C13.9306 30.429 14.0405 30.3991 14.1415 30.3488C14.2426 30.2985 14.3327 30.2287 14.4068 30.1436C14.4808 30.0585 14.5374 29.9596 14.5733 29.8526C14.6091 29.7455 14.6235 29.6325 14.6157 29.5199C14.6085 29.4192 14.6094 29.3189 14.6094 29.2186C14.6101 25.6065 15.7565 22.0877 17.8835 19.1683C20.3139 20.7552 21.7364 22.2883 21.7949 23.4304C21.705 24.5169 21.3619 25.5671 20.7929 26.497C20.5398 27.0194 20.2742 27.5691 20.0292 28.1579C19.9858 28.2621 19.9634 28.3738 19.9632 28.4866C19.963 28.5995 19.985 28.7113 20.0281 28.8157C20.1149 29.0264 20.282 29.194 20.4924 29.2816C20.5966 29.325 20.7084 29.3474 20.8212 29.3476C20.9341 29.3477 21.0459 29.3257 21.1502 29.2827C21.361 29.1958 21.5286 29.0288 21.6162 28.8183C21.8482 28.2611 22.1004 27.7407 22.34 27.246C23.0535 26.0634 23.4563 24.7195 23.5111 23.3394C23.4223 21.606 21.8828 19.7526 18.9648 17.8239C20.2806 16.3345 21.8434 15.0831 23.5845 14.1249C25.2583 17.3865 27.2723 19.108 29.4714 19.108C29.6314 19.108 29.7912 19.099 29.9502 19.0811C31.4737 18.9841 32.9279 18.4089 34.1056 17.4375C34.8622 16.8525 35.1756 16.6108 36.9103 17.2167C38.5305 17.7808 40.2384 17.0737 41.7857 15.2385C43.125 16.198 44.3196 17.3449 45.3327 18.6441C44.2982 19.7489 43.4842 21.041 42.9344 22.4511C42.2013 24.0515 41.7057 25.0372 40.7943 25.1228C40.2023 25.1596 39.6085 25.1571 39.0168 25.1152C36.7492 25.0036 33.929 24.8714 31.9144 28.8318C31.4576 29.7241 31.1507 30.6856 31.0059 31.6776C30.9743 31.9033 31.0337 32.1323 31.1709 32.3142C31.3082 32.4962 31.5121 32.6161 31.7377 32.6477C31.7776 32.6535 31.8179 32.6563 31.8581 32.6561C32.0652 32.6559 32.2652 32.5808 32.4213 32.4448C32.5775 32.3088 32.6792 32.121 32.7079 31.9159C32.8247 31.1111 33.0748 30.3313 33.4477 29.6085C34.9566 26.6418 36.7139 26.7286 38.935 26.8319C39.6066 26.8789 40.2807 26.8797 40.9525 26.8344C42.9016 26.6506 43.7127 24.8794 44.497 23.1665C44.9412 22.0427 45.5633 20.9978 46.3395 20.0717C47.4889 21.8905 48.2834 23.9105 48.681 26.0249C48.7016 26.1359 48.744 26.2418 48.8055 26.3365C48.8671 26.4311 48.9467 26.5127 49.0398 26.5766C49.1329 26.6404 49.2377 26.6853 49.3482 26.7087C49.4586 26.732 49.5726 26.7333 49.6836 26.7126C49.7946 26.6919 49.9004 26.6495 49.995 26.5878C50.0896 26.5262 50.1711 26.4465 50.2349 26.3533C50.2987 26.2602 50.3435 26.1553 50.3667 26.0448C50.39 25.9343 50.3912 25.8204 50.3704 25.7094C49.5792 21.5283 47.3995 17.7368 44.1844 14.9492C40.9693 12.1616 36.9073 10.5412 32.6563 10.3505V9.40098C32.6563 8.91969 32.7917 8.44811 33.047 8.04008C33.3022 7.63204 33.667 7.30399 34.0998 7.09335C34.5779 7.65046 35.1708 8.09766 35.8378 8.40434C36.5048 8.71101 37.2303 8.86992 37.9644 8.87017C38.6606 8.8642 39.3507 8.74019 40.0054 8.50342C41.1016 8.11974 42.1412 7.59049 43.0963 6.92989C43.5098 6.55875 44.0186 6.31011 44.5654 6.21183C45.1123 6.11355 45.6758 6.16953 46.1926 6.37348C46.3667 6.41813 46.5504 6.40709 46.7179 6.34191C46.8853 6.27674 47.0282 6.1607 47.1263 6.01013C47.2244 5.85956 47.2728 5.68203 47.2647 5.5025C47.2567 5.32298 47.1926 5.15049 47.0814 5.00931C46.8972 4.77513 42.5214 -0.706329 38.3093 0.0779364C34.2436 0.835768 33.7673 3.3018 33.5691 5.44038C32.864 5.73908 32.2521 6.22146 31.7969 6.83723C31.3418 6.22135 30.7297 5.73887 30.0246 5.44011C29.8263 3.30161 29.3501 0.835716 25.2844 0.0779364C21.0719 -0.710523 16.6966 4.77555 16.5123 5.00927C16.4012 5.15046 16.337 5.32294 16.329 5.50247C16.3209 5.682 16.3694 5.85953 16.4675 6.0101C16.5656 6.16067 16.7084 6.2767 16.8759 6.34188C17.0433 6.40705 17.227 6.41809 17.4011 6.37344C17.9179 6.16937 18.4814 6.11334 19.0283 6.21162C19.5752 6.3099 20.084 6.55861 20.4974 6.92985C21.4526 7.59046 22.4922 8.11971 23.5883 8.5034C24.243 8.74041 24.9331 8.86443 25.6294 8.87015C26.3635 8.86987 27.0889 8.71094 27.756 8.40425C28.423 8.09755 29.0159 7.65034 29.494 7.09323C29.9268 7.30389 30.2916 7.63197 30.5468 8.04003C30.8021 8.44808 30.9374 8.91967 30.9375 9.40098V10.3342C28.2297 10.4556 25.58 11.1597 23.1691 12.3984C20.7582 13.6371 18.6429 15.3813 16.9675 17.512ZM38.624 1.76731C40.5069 1.41358 42.7577 3.04882 44.2901 4.51286C43.5133 4.6743 42.783 5.00925 42.1539 5.49267C41.315 6.07617 40.4008 6.54326 39.4364 6.88118C38.8417 7.14066 38.1866 7.23015 37.5441 7.13969C36.9015 7.04923 36.2967 6.78237 35.7967 6.36878L38.068 5.41546C38.1724 5.372 38.2672 5.30836 38.3469 5.2282C38.4266 5.14804 38.4898 5.05294 38.5327 4.94834C38.5756 4.84374 38.5974 4.7317 38.597 4.61864C38.5965 4.50559 38.5737 4.39373 38.5299 4.28949C38.4861 4.18526 38.4222 4.09068 38.3418 4.01119C38.2614 3.9317 38.1661 3.86886 38.0614 3.82626C37.9567 3.78367 37.8446 3.76216 37.7315 3.76297C37.6185 3.76378 37.5067 3.78689 37.4026 3.83098L35.3899 4.67583C35.6288 3.20581 36.2323 2.21336 38.624 1.76731ZM24.1573 6.88118C23.1929 6.54326 22.2788 6.07617 21.4399 5.49267C20.8102 5.00852 20.0789 4.67339 19.3011 4.51247C20.831 3.04801 23.0751 1.41528 24.9697 1.76733C27.3615 2.21328 27.9649 3.20592 28.2038 4.6757L26.1912 3.83098C26.0872 3.78728 25.9756 3.76451 25.8627 3.76395C25.7499 3.76339 25.638 3.78506 25.5336 3.82773C25.4291 3.8704 25.3341 3.93322 25.2539 4.01262C25.1737 4.09201 25.1099 4.18643 25.0662 4.29046C25.0225 4.3945 24.9998 4.50613 24.9992 4.61897C24.9986 4.73181 25.0203 4.84366 25.063 4.94812C25.1056 5.05259 25.1685 5.14762 25.2479 5.22781C25.3273 5.30799 25.4217 5.37176 25.5257 5.41545L27.7975 6.36882C27.2973 6.78217 26.6923 7.04886 26.0498 7.1393C25.4072 7.22974 24.7522 7.1404 24.1573 6.88118ZM37.4768 15.5937C35.0447 14.7452 34.1463 15.2341 33.0544 16.0775C32.125 16.8538 30.9692 17.3082 29.76 17.3729C27.7239 17.6062 26.0851 15.2452 25.1213 13.381C27.5566 12.3543 30.1959 11.9031 32.834 12.0624C35.4721 12.2217 38.0379 12.9872 40.332 14.2995C39.5873 15.138 38.5368 15.964 37.4768 15.5937Z"
                                                    fill="#06add9" />
                                            </g>
                                            <defs>
                                                <clipPath id="clip0_49_535">
                                                    <rect width="55" height="55" fill="white" />
                                                </clipPath>
                                            </defs>
                                        </svg>

                                    </div>
                                    <div class="info">
                                        <h6 class="title">95%</h6>
                                        <p> Satisfaction Rate</p>
                                    </div>
                                    <div class="icon-last">

                                        <svg width="54" height="49" viewBox="0 0 54 49" fill="none"
                                            xmlns="http://www.w3.org/2000/svg">
                                            <rect y="19" width="6" height="30" fill="#06add9" />
                                            <rect x="12" y="9" width="6" height="40" fill="#6F8CA0" />
                                            <rect x="36" y="13" width="6" height="36" fill="#FF9933" />
                                            <rect x="24" y="26" width="6" height="23" fill="#DBDBDB" />
                                            <rect x="48" width="6" height="49" fill="#A6CE38" />
                                        </svg>

                                    </div>
                                </div>
                            </div>
                            <!-- autohr button area -->
                            <div class="author-button-area">
                                <!-- author-area start -->

                                <!-- author-area end -->
                                <a href="aboutus.php" class="rts-btn btn-primary">Learn More</a>
                            </div>
                            <!-- autohr button area end -->
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- about area end -->



    <?php include("components/monitoringCard.php") ?>

    <?php include("components/amcCard.php") ?>







    <!-- rts feedback area start -->
    <div class="rts-feedback-area-solar-energy rts-section-gap">
        <div class="container">
            <div class="row">
                <div class="col-lg-12">
                    <div class="title-area-center">
                        <p class="pre skew-up">
                            <span> Our</span> Clients Review
                        </p>
                        <h2 class="title skew-up">
                            Testimonial
                        </h2>
                    </div>
                </div>
            </div>
            <div class="row mt--30 g-24">

                <div class="soalr-feedback-wrapper-main">
                    <div class="swiper swiper-feedback-solar">
                        <div class="swiper-wrapper">
                            <div class="swiper-slide">
                                <!-- single customer feedback -->
                                <div class="rts-single-feedback-solar-energy">
                                    <div class="client-image">
                                        <img src="assets/images/team/21.png" alt="team">
                                    </div>
                                    <div class="content">
                                        <p class="para">
                                            "Novosafe has transformed our operations! Their pump services are incredibly
                                            efficient, and the maintenance team is always reliable. We’ve noticed fewer
                                            breakdowns since we started using their services."
                                        </p>
                                        <div class="cottom-review-area">
                                            <div class="stars">
                                                <i class="fa-solid fa-star"></i>
                                                <i class="fa-solid fa-star"></i>
                                                <i class="fa-solid fa-star"></i>
                                                <i class="fa-solid fa-star"></i>
                                                <i class="fa-solid fa-star"></i>
                                            </div>
                                            <p>5.0 Out of 5 Star</p>
                                        </div>
                                    </div>
                                </div>
                                <!-- single customer feedback end -->
                            </div>
                            <div class="swiper-slide">
                                <!-- single customer feedback -->
                                <div class="rts-single-feedback-solar-energy">
                                    <div class="client-image">
                                        <img src="assets/images/team/21.png" alt="team">
                                    </div>
                                    <div class="content">
                                        <p class="para">
                                            "We rely on Novosafe for our annual maintenance contracts, and their service
                                            is always outstanding. Their team is proactive and ensures our pumps are
                                            operating at peak efficiency."
                                        </p>
                                        <div class="cottom-review-area">
                                            <div class="stars">
                                                <i class="fa-solid fa-star"></i>
                                                <i class="fa-solid fa-star"></i>
                                                <i class="fa-solid fa-star"></i>
                                                <i class="fa-solid fa-star"></i>
                                                <i class="fa-solid fa-star"></i>
                                            </div>
                                            <p>5.0 Out of 5 Star</p>
                                        </div>
                                    </div>
                                </div>
                                <!-- single customer feedback end -->
                            </div>
                            <div class="swiper-slide">
                                <!-- single customer feedback -->
                                <div class="rts-single-feedback-solar-energy">
                                    <div class="client-image">
                                        <img src="assets/images/team/21.png" alt="team">
                                    </div>
                                    <div class="content">
                                        <p class="para">
                                            "The pump overhauling service by Novosafe exceeded our expectations. Their
                                            meticulous approach has rejuvenated our equipment, resulting in improved
                                            performance and longevity."
                                        </p>
                                        <div class="cottom-review-area">
                                            <div class="stars">
                                                <i class="fa-solid fa-star"></i>
                                                <i class="fa-solid fa-star"></i>
                                                <i class="fa-solid fa-star"></i>
                                                <i class="fa-solid fa-star"></i>
                                                <i class="fa-solid fa-star"></i>
                                            </div>
                                            <p>5.0 Out of 5 Star</p>
                                        </div>
                                    </div>
                                </div>
                                <!-- single customer feedback end -->
                            </div>
                            <div class="swiper-slide">
                                <!-- single customer feedback -->
                                <div class="rts-single-feedback-solar-energy">
                                    <div class="client-image">
                                        <img src="assets/images/team/21.png" alt="team">
                                    </div>
                                    <div class="content">
                                        <p class="para">
                                            "Novosafe's expertise in generator maintenance has been a game-changer for
                                            us. Their team's regular checks and updates have drastically reduced
                                            unexpected failures."
                                        </p>
                                        <div class="cottom-review-area">
                                            <div class="stars">
                                                <i class="fa-solid fa-star"></i>
                                                <i class="fa-solid fa-star"></i>
                                                <i class="fa-solid fa-star"></i>
                                                <i class="fa-solid fa-star"></i>
                                                <i class="fa-solid fa-star"></i>
                                            </div>
                                            <p>5.0 Out of 5 Star</p>
                                        </div>
                                    </div>
                                </div>
                                <!-- single customer feedback end -->
                            </div>
                        </div>
                        <!-- <div class="swiper-button-next"></div>
                    <div class="swiper-button-prev"></div> -->
                        <div class="swiper-pagination"></div>
                    </div>
                </div>
            </div>
        </div>
    </div>



    <?php include("components/cta.php") ?>



    <!-- solari category area start -->
    <?php /* <div class="solari-category-area-start rts-section-gapBottom">
<div class="container">
<div class="row align-items-center">
<div class="col-xl-4 col-lg-6 col-md-12">
<div class="category-title-left-area">
<h2 class="title">Our Valuable <br>
Clients </h2>
<p class="disc">
Trusted by industry leaders and organizations across various sectors, we take pride in
delivering exceptional service and innovative solutions to our esteemed clients.
</p>

</div>
</div>
<div class="col-xl-8 col-lg-6 col-md-12 pl--50 pl_md--10 pl_sm--10 mt_md--50 mt_sm--50">
<div class="swiper-category-shop">
<div class="swiper mySwiper-category-soalr">
<div class="swiper-wrapper">
<div class="swiper-slide">
 <!-- single category -->
 <div class="single-category">
     <a href="#" class="thumbnail">
         <img src="assets/images/clients/cummins_logo.png" alt="category">
     </a>
     <div class="single-category">
         <a href="#">
             <!-- <h5 class="title">Client 1</h5> -->
         </a>

     </div>
 </div>
 <!-- single category end -->
</div>
<div class="swiper-slide">
 <!-- single category -->
 <div class="single-category">
     <a href="#" class="thumbnail">
         <img src="assets/images/clients/jcb_logo.png" alt="category">
     </a>
     <div class="single-category">
         <a href="#">
             <!-- <h5 class="title">Client 2</h5> -->
         </a>

     </div>
 </div>
 <!-- single category end -->
</div>
<div class="swiper-slide">
 <!-- single category -->
 <div class="single-category">
     <a href="#" class="thumbnail">
         <img src="assets/images/clients/john_deere_logo.png" alt="category">
     </a>
     <div class="single-category">
         <a href="#">
             <!-- <h5 class="title">Client 3</h5> -->
         </a>

     </div>
 </div>
 <!-- single category end -->
</div>
<div class="swiper-slide">
 <!-- single category -->
 <div class="single-category">
     <a href="#" class="thumbnail">
         <img src="assets/images/clients/man_logo.png" alt="category">
     </a>
     <div class="single-category">
         <a href="#">
             <!-- <h5 class="title">Client 4</h5> -->
         </a>

     </div>
 </div>
 <!-- single category end -->
</div>
<div class="swiper-slide">
 <!-- single category -->
 <div class="single-category">
     <a href="#" class="thumbnail">
         <img src="assets/images/clients/mitsubishi_logo.png" alt="category">
     </a>
     <div class="single-category">
         <a href="#">
             <!-- <h5 class="title">Client 5</h5> -->
         </a>

     </div>
 </div>
 <!-- single category end -->
</div>
<div class="swiper-slide">
 <!-- single category -->
 <div class="single-category">
     <a href="#" class="thumbnail">
         <img src="assets/images/clients/mitsubishi_logo.png" alt="category">
     </a>
     <div class="single-category">
         <a href="#">
             <!-- <h5 class="title">Cient 6</h5> -->
         </a>

     </div>
 </div>
 <!-- single category end -->
</div>

</div>
<div class="swiper-pagination"></div>
</div>
</div>

</div>
</div>
</div>
</div>
*/ ?>
    <!-- solari category area end -->



    <!-- hop page call to action area start -->
    <div class="cta-call-to-action-shop ptb--60">
        <div class="container">
            <div class="row g-xl-0 g-md-5 g-sm-5 g-5">
                <div class="col-lg-3 col-md-6 col-sm-6 co-12">
                    <!-- single call to actiona rea start -->
                    <div class="single-counter-area">
                        <div class="icon">
                            <svg width="50" height="51" viewBox="0 0 50 51" fill="none"
                                xmlns="http://www.w3.org/2000/svg">
                                <path
                                    d="M25 10.1133L28.7109 4.05859C30.1758 1.71484 32.8125 0.25 35.6445 0.25H35.9375C40.2344 0.25 43.75 3.76562 43.75 8.0625C43.75 9.91797 43.1641 11.4805 42.1875 12.75H45.3125C47.8516 12.75 50 14.8984 50 17.4375V23.6875C50 25.7383 48.6328 27.4961 46.875 28.1797V44C46.875 47.5156 44.043 50.25 40.625 50.25H9.375C5.85938 50.25 3.125 47.5156 3.125 44V28.1797C1.26953 27.4961 0 25.7383 0 23.6875V17.4375C0 14.8984 2.05078 12.75 4.6875 12.75H7.71484C6.73828 11.4805 6.25 9.91797 6.25 8.0625C6.25 3.76562 9.66797 0.25 14.0625 0.25H14.2578C17.0898 0.25 19.7266 1.71484 21.1914 4.05859L25 10.1133ZM35.6445 3.375C33.8867 3.375 32.3242 4.35156 31.3477 5.71875L26.9531 12.75H35.9375C38.4766 12.75 40.625 10.6992 40.625 8.0625C40.625 5.52344 38.4766 3.375 35.9375 3.375H35.6445ZM22.9492 12.75L18.5547 5.71875C17.5781 4.35156 16.0156 3.375 14.2578 3.375H14.0625C11.4258 3.375 9.375 5.52344 9.375 8.0625C9.375 10.6992 11.4258 12.75 14.0625 12.75H22.9492ZM4.6875 15.875C3.80859 15.875 3.125 16.6562 3.125 17.4375V23.6875C3.125 24.5664 3.80859 25.25 4.6875 25.25H23.4375V15.875H4.6875ZM26.5625 25.25H45.3125C46.0938 25.25 46.875 24.5664 46.875 23.6875V17.4375C46.875 16.6562 46.0938 15.875 45.3125 15.875H26.5625V25.25ZM23.4375 28.375H6.25V44C6.25 45.7578 7.61719 47.125 9.375 47.125H23.4375V28.375ZM26.5625 47.125H40.625C42.2852 47.125 43.75 45.7578 43.75 44V28.375H26.5625V47.125Z"
                                    fill="white" />
                            </svg>
                        </div>
                        <div class="content">
                            <h6 class="title">Special offer</h6>
                            <p class="disc">Only for regular</p>
                        </div>
                    </div>
                    <!-- single call to actiona rea end -->
                </div>
                <div class="col-lg-3 col-md-6 col-sm-6 co-12">
                    <!-- single call to actiona rea start -->
                    <div class="single-counter-area">
                        <div class="icon">

                            <svg width="63" height="51" viewBox="0 0 63 51" fill="none"
                                xmlns="http://www.w3.org/2000/svg">
                                <path
                                    d="M6.5 40.875C2.98438 40.875 0.25 38.1406 0.25 34.625V6.5C0.25 3.08203 2.98438 0.25 6.5 0.25H34.625C38.043 0.25 40.875 3.08203 40.875 6.5V9.625H47.2227C48.5898 9.625 49.8594 10.3086 50.7383 11.2852L58.4531 20.2695C59.1367 21.1484 59.625 22.2227 59.625 23.2969V37.75H61.1875C61.9688 37.75 62.75 38.5312 62.75 39.3125C62.75 40.1914 61.9688 40.875 61.1875 40.875H56.5C56.5 46.0508 52.3008 50.25 47.125 50.25C41.8516 50.25 37.75 46.0508 37.75 40.875H25.1523C25.1523 46.0508 21.0508 50.25 15.7773 50.25C10.6016 50.25 6.40234 46.0508 6.40234 40.875H6.5ZM3.375 6.5V34.625C3.375 36.3828 4.74219 37.75 6.5 37.75H6.98828C8.25781 34.1367 11.7734 31.5 15.875 31.5C19.8789 31.5 23.3945 34.1367 24.6641 37.75H37.75V6.5C37.75 4.83984 36.2852 3.375 34.625 3.375H6.5C4.74219 3.375 3.375 4.83984 3.375 6.5ZM55.9141 22.125L48.3945 13.3359C48.1016 12.9453 47.6133 12.75 47.2227 12.75H40.875V22.125H55.9141ZM40.875 25.25V33.9414C42.4375 32.4766 44.6836 31.5 47.125 31.5C51.1289 31.5 54.6445 34.1367 55.9141 37.75H56.5V25.25H40.875ZM15.875 34.625C12.3594 34.625 9.625 37.457 9.625 40.875C9.625 44.3906 12.3594 47.125 15.875 47.125C19.293 47.125 22.125 44.3906 22.125 40.875C22.125 37.457 19.293 34.625 15.875 34.625ZM47.125 47.125C50.543 47.125 53.375 44.3906 53.375 40.875C53.375 37.457 50.543 34.625 47.125 34.625C43.6094 34.625 40.875 37.457 40.875 40.875C40.875 44.3906 43.6094 47.125 47.125 47.125Z"
                                    fill="white" />
                            </svg>

                        </div>
                        <div class="content">
                            <h6 class="title">Free Delivery</h6>
                            <p class="disc">Orders from all item</p>
                        </div>
                    </div>
                    <!-- single call to actiona rea end -->
                </div>
                <div class="col-lg-3 col-md-6 col-sm-6 co-12">
                    <!-- single call to actiona rea start -->
                    <div class="single-counter-area">
                        <div class="icon">

                            <svg width="50" height="51" viewBox="0 0 50 51" fill="none"
                                xmlns="http://www.w3.org/2000/svg">
                                <path
                                    d="M33.8867 16.3633C34.4727 16.9492 34.4727 18.0234 33.8867 18.6094L18.2617 34.2344C17.6758 34.8203 16.6016 34.8203 16.0156 34.2344C15.4297 33.6484 15.4297 32.5742 16.0156 31.9883L31.6406 16.3633C32.2266 15.7773 33.3008 15.7773 33.8867 16.3633ZM16.4062 19C16.4062 17.7305 17.3828 16.6562 18.75 16.6562C20.0195 16.6562 21.0938 17.7305 21.0938 19C21.0938 20.3672 20.0195 21.3438 18.75 21.3438C17.3828 21.3438 16.4062 20.3672 16.4062 19ZM28.9062 31.5C28.9062 30.2305 29.8828 29.1562 31.25 29.1562C32.5195 29.1562 33.5938 30.2305 33.5938 31.5C33.5938 32.8672 32.5195 33.8438 31.25 33.8438C29.8828 33.8438 28.9062 32.8672 28.9062 31.5ZM33.4961 4.74219C36.7188 4.15625 40.1367 5.13281 42.6758 7.57422C45.1172 10.1133 46.0938 13.5312 45.5078 16.7539C48.1445 18.6094 50 21.7344 50 25.25C50 28.8633 48.1445 31.8906 45.5078 33.8438C46.0938 37.0664 45.1172 40.4844 42.6758 42.9258C40.1367 45.4648 36.7188 46.4414 33.4961 45.8555C31.6406 48.4922 28.5156 50.25 25 50.25C21.3867 50.25 18.2617 48.4922 16.4062 45.8555C13.1836 46.4414 9.76562 45.4648 7.22656 42.9258C4.78516 40.4844 3.80859 37.0664 4.39453 33.8438C1.75781 31.8906 0 28.8633 0 25.25C0 21.7344 1.75781 18.6094 4.39453 16.7539C3.80859 13.5312 4.78516 10.1133 7.22656 7.57422C9.76562 5.13281 13.1836 4.15625 16.4062 4.74219C18.2617 2.10547 21.3867 0.25 24.9023 0.25C28.5156 0.25 31.6406 2.10547 33.4961 4.74219ZM17.9688 8.45312L16.6992 8.0625C14.2578 7.28125 11.4258 7.86719 9.47266 9.82031C7.51953 11.7734 6.93359 14.6055 7.71484 17.0469L8.10547 18.3164L6.93359 18.9023C4.58984 20.0742 3.125 22.5156 3.125 25.25C3.125 28.082 4.58984 30.4258 6.93359 31.6953L8.10547 32.2812L7.71484 33.5508C6.93359 35.9922 7.51953 38.8242 9.47266 40.7773C11.4258 42.7305 14.2578 43.3164 16.6992 42.5352L17.9688 42.1445L18.5547 43.3164C19.8242 45.6602 22.168 47.125 25 47.125C27.7344 47.125 30.0781 45.6602 31.3477 43.3164L31.9336 42.1445L33.2031 42.5352C35.6445 43.3164 38.4766 42.7305 40.4297 40.7773C42.3828 38.8242 42.9688 35.9922 42.1875 33.5508L41.7969 32.2812L42.9688 31.6953C45.3125 30.4258 46.875 28.082 46.875 25.25C46.875 22.5156 45.3125 20.0742 42.9688 18.9023L41.7969 18.3164L42.1875 17.0469C42.9688 14.6055 42.3828 11.7734 40.4297 9.82031C38.4766 7.86719 35.6445 7.28125 33.2031 8.0625L31.9336 8.45312L31.3477 7.28125C30.0781 4.9375 27.7344 3.375 25 3.375C22.168 3.375 19.8242 4.9375 18.5547 7.28125L17.9688 8.45312Z"
                                    fill="white" />
                            </svg>

                        </div>
                        <div class="content">
                            <h6 class="title">Awesome Sales</h6>
                            <p class="disc">Best Prices</p>
                        </div>
                    </div>
                    <!-- single call to actiona rea end -->
                </div>
                <div class="col-lg-3 col-md-6 col-sm-6 co-12">
                    <!-- single call to actiona rea start -->
                    <div class="single-counter-area none">
                        <div class="icon">
                            <svg width="51" height="53" viewBox="0 0 51 53" fill="none"
                                xmlns="http://www.w3.org/2000/svg">
                                <path
                                    d="M19.6523 24.125V36.625C19.6523 38.3828 18.2852 39.75 16.5273 39.75H13.4023C9.98438 39.75 7.15234 36.918 7.15234 33.5V27.25C7.15234 23.832 9.88672 21 13.4023 21H16.5273C18.1875 21 19.6523 22.4648 19.6523 24.125ZM16.5273 36.625V24.125H13.4023C11.6445 24.125 10.2773 25.5898 10.2773 27.25V33.5C10.2773 35.2578 11.6445 36.625 13.4023 36.625H16.5273ZM38.4023 39.75V39.8477H35.375C33.6172 39.8477 32.25 38.4805 32.25 36.7227V24.2227C32.25 22.5625 33.6172 21.0977 35.375 21.0977H38.4023C41.8203 21.0977 44.6523 23.832 44.6523 27.25V33.5C44.6523 36.918 41.8203 39.75 38.4023 39.75ZM35.2773 24.125L35.1797 36.625H38.3047C39.9648 36.625 41.4297 35.2578 41.4297 33.5V27.25C41.4297 25.5898 39.9648 24.125 38.3047 24.125H35.2773ZM28.3438 2.44531C41.2344 3.61719 51 14.9453 50.8047 27.9336V44.5352C50.8047 48.832 47.2891 52.25 42.9922 52.25H24.3398C21.5078 52.25 19.2617 49.7109 19.75 46.6836C20.2383 44.4375 22.2891 42.875 24.5352 42.875H30.1992C32.0547 42.875 33.9102 43.8516 34.7891 45.5117C35.4727 46.7812 35.4727 48.0508 34.9844 49.125H43.1875C45.7266 49.125 47.875 46.9766 47.875 44.4375V27.9336C47.875 16.5078 39.3789 6.54688 27.9531 5.47266C14.8672 4.30078 4.41797 14.8477 4.125 27.25V28.9102C4.02734 29.6914 3.34375 30.375 2.5625 30.375C1.68359 30.375 0.902344 29.6914 0.902344 28.8125L1 27.3477C1.39062 12.9922 13.3047 0.980469 28.3438 2.44531ZM30.5898 49.125C31.4688 49.125 32.1523 48.4414 32.1523 47.5625C32.1523 46.7812 31.3711 46 30.5898 46H24.3398C23.4609 46 22.7773 46.7812 22.7773 47.5625C22.7773 48.4414 23.4609 49.125 24.3398 49.125H30.5898Z"
                                    fill="white" />
                            </svg>
                        </div>
                        <div class="content">
                            <h6 class="title">Support 24/7</h6>
                            <p class="disc">Contact us 24 Hours</p>
                        </div>
                    </div>
                    <!-- single call to actiona rea end -->
                </div>
            </div>
        </div>
    </div>
    <!-- hop page call to action area end -->

    <!-- header style two -->
    <div id="side-bar" class="side-bar header-two">
        <button class="close-icon-menu"><i class="far fa-times"></i></button>
        <!-- inner menu area desktop start -->
        <div class="inner-main-wrapper-desk">
            <div class="thumbnail">
                <img src="assets/images/banner/04.jpg" alt="elevate">
            </div>
            <div class="inner-content">
                <h4 class="title"> We Provide The Power of
                    Renewable Energy.</h4>
                <p class="disc">
                    We successfully cope with tasks of varying complexity, provide long-term guarantees and regularly
                    master
                    new technologies.
                </p>
                <div class="footer">
                    <h4 class="title">Got a project in mind?</h4>
                    <a href="contact.php" class="rts-btn btn-primary">Let's talk</a>
                </div>
            </div>
        </div>

    </div>
    <!-- header style two End -->

    <?php include("components/footer.php") ?>