<?php include 'header.php'; ?>

<!-- Page Breadcrumb Area -->
<div class="page_title">
	<div class="container">
		<div class="row">
			<div class="col-md-12">
				<div class="bread_crumb-h5">
					<h5 class="page_tittle text-white text-center text-uppercase">Career</h5>
				</div>
				<div class="bread_crumb text-center text-lg-left">
					<a href="index.php">
						Home<i class="fa fa-angle-right pl-2" aria-hidden="true"></i>
					</a>
					<a href="#">
						<span class="activeColor">Career</span>
					</a>
				</div>
			</div>
		</div>
	</div>
</div>
<!-- End Page Breadcrumb Area -->

<!-- contact page -->
<div class="contact-page">
	<div class="container">
		<div class="row">

			<div class="col-md-5 col-lg-5">
				<div class="block p-3">
					<div class="career position-relative">
					    	<img class="open" src="img/open.png" alt="">
						<h4>We’re committed to making a difference in the lives of startup employees</h4>
							<img class="closee" src="img/close.png" alt="">
					</div>

				</div>
			</div>

			<div class="col-md-7 col-lg-7">
				<div class="career-block">
					<form action="#" method="post" id="cf">
						<div class="row">
							<div class="col-md-12">
								<div class="form-group">
									<input type="text" class="form-control" id="fname" name="name" placeholder="Name" required="">
								</div>
							</div>
						</div>
						<div class="row">
							<div class="col-md-12">
								<div class="form-group">
									<input type="email" class="form-control" id="email" name="email" placeholder="Email Address" required="">
								</div>
							</div>
							<div class="col-md-12">
								<div class="form-group">
									<input type="text" class="form-control" id="phone" name="phone" placeholder="Phone">
								</div>
							</div>
						</div>
						<div class="row">
							<div class="col-md-12">
								<div class="form-group">
									<input type="file" class="form-control" id="file" name="file" placeholder="Phone">
								</div>
							</div>
							<div class="col-md-12">
								<div class="form-group">
									<textarea class="form-control" id="latter" name="latter" rows="7" placeholder="Cover letter"></textarea>
								</div>
							</div>
						</div>
						<div class="g-recaptcha" data-sitekey="6LdQE6EdAAAAAOLWdkqAhgqe7Bt49lzXHkIVPv1z"></div>
						<button type="submit" id="submit" name="submit" class="btn btn-primary border-0">send a
							message</button>
					</form>
				</div>
			</div>


		</div>
	</div>
</div>
<!-- End Contact Page -->

<!-- contact page -->
<div class="career-page">
	<div class="container-fluid employee-container">
		<div class="d-flex justify-content-center mb-5">
			<h1 class="text-light" style="font-weight: 600;">Helping Our Employees Thrive</h1>
		</div>

		<div class="row">
			<div class="col-sm-4">
				<div class="employee-div">
					<div class="cicon">
						<img src="img/quality.png" alt="">
					</div>
					<div class="ccdiv">
						<h3>Quality-driven environment</h3>
						<p>We value flat hierarchies, clear communication, and full ownership and responsibility.</p>
					</div>
				</div>
			</div>
			<div class="col-sm-4">
				<div class="employee-div" >
					<div class="cicon">
						<img src="img/competition.png" alt="">
					</div>
					<div class="ccdiv">
						<h3>Competitive compensation</h3>
						<p>Pitch offers competitive compensation and stock options to all employees.</p>
					</div>
				</div>
			</div>
			<div class="col-sm-4">
				<div class="employee-div">
					<div class="cicon">
						<img src="img/growth.png" alt="">
					</div>
					<div class="ccdiv">
						<h3>Employee Development</h3>
						<p>Pitch equips employees with in-house learning and development courses plus an educational stipend.</p>
					</div>
				</div>
			</div>
		</div>
		<div class="row">
			<div class="col-sm-4">
				<div class="employee-div">
					<div class="cicon">
						<img src="img/insurance.png" alt="">
					</div>
					<div class="ccdiv">
						<h3>Healthy work-life balance</h3>
						<p>Remote-friendly environment with flexible hours and vacation. Observe public holidays according to your country and culture.</p>
					</div>
				</div>
			</div>
			<div class="col-sm-4">
				<div class="employee-div">
					<div class="cicon">
						<img src="img/people.png" alt="">
					</div>
					<div class="ccdiv">
						<h3>Parent-friendly culture</h3>
						<p>We believe that life doesn’t begin when your work day ends and encourage our employees to spend time with family and loved ones.</p>
					</div>
				</div>
			</div>
			<div class="col-sm-4">
				<div class="employee-div">
					<div class="cicon">
						<img src="img/target.png" alt="">
					</div>
					<div class="ccdiv">
						<h3>Well-being focused</h3>
						<p>All the support you need to do your work without burning out or stagnating, with physical and mental health programs.</p>
					</div>
				</div>
			</div>

		</div>
	</div>
</div>

<script>
	document.addEventListener("DOMContentLoaded", function() {
		const form = document.querySelector('#cf');

		form.addEventListener('submit', function(event) {
			event.preventDefault();


			const formData = new FormData(form);

			fetch('career_ajax.php', {
					method: 'POST',
					body: formData
				})
				.then(response => response.json())
				.then(data => {
					if (data.status === 'success') {
						alert('Career application submitted successfully.');
						form.reset();
					} else {
						alert('Failed to submit career application.');
						console.error('Error:', data.message);
					}
				})
				.catch(error => {
					console.error('Error:', error);
					alert('An error occurred while submitting the form.');
				}).finally(() => {
					grecaptcha.reset();
				})
		});
	});
</script>

<?php include 'footer.php'; ?>