<?php include 'header.php'; ?>

<!-- Page Breadcrumb Area -->
<div class="page_title">
  <div class="container">
    <div class="row">
      <div class="col-md-12">
        <div class="bread_crumb-h5">
          <h5 class="page_tittle text-white text-center text-uppercase">contact us</h5>
        </div>
        <div class="bread_crumb text-center text-lg-left">
          <a href="#">
            Home<i class="fa fa-angle-right pl-2" aria-hidden="true"></i>
          </a>
          <a href="#">
            <span class="activeColor">Contact Us</span>
          </a>
        </div>
      </div>
    </div>
  </div>
</div>
<!-- End Page Breadcrumb Area -->

<!-- contact page -->
<div class="contact-page">
  <div class="container">
    <div class="row">
      <div class="col-md-5 col-lg-4">
        <div class="block contact_address">
          <div class="title">
            <h4>Call Us</h4>
            <h1>or fill the form</h1>
          </div>
          <div class="media border-bottom contact-media wow fadeInUp animated" data-wow-delay="100ms"
            data-wow-duration="1500ms">
            <img class="mr-3" src="img/call.png" alt="Generic placeholder image">
            <div class="media-body">
              <h5 class="mt-0 mb-0">+971 6 551 7022 <br> 056 7330509</h5>
              Don't hesitate to contact us!.
            </div>
          </div>
          <div class="media border-bottom contact-media wow fadeInUp animated" data-wow-delay="100ms"
            data-wow-duration="1500ms">
            <img class="mr-3" src="img/mail.png" alt="Generic placeholder image">
            <div class="media-body">
              <h5 class="mt-0 mb-0">Email Address:</h5>
              info@smapetrochem.com
            </div>
          </div>
          <div class="media border-bottom contact-media wow fadeInUp animated" data-wow-delay="100ms"
            data-wow-duration="1500ms">
            <img class="mr-3" src="img/map.png" alt="Generic placeholder image">
            <div class="media-body">
              <h5 class="mt-0 mb-0">Company Headquarters</h5>
              Plot No. PTC-02,15 Hamriyah Free Zone – Sharjah UAE
            </div>
          </div>
          <div class="block mt-4 social-media d-flex justify-content-center">
            <a class="ct-twitter d-flex justify-content-center align-items-center" href="#"><i class="fa fa-twitter"
                aria-hidden="true"></i></a>
            <a class="ct-facebookr d-flex justify-content-center align-items-center" href="#"><i class="fa fa-facebook"
                aria-hidden="true"></i></a>
            <a class="ct-instagramr d-flex justify-content-center align-items-center" href="https://www.instagram.com/smapetrochem"><i
                class="fa fa-instagram" aria-hidden="true"></i></a>
          </div>
        </div>
      </div>
      <div class="col-md-7 col-lg-8">
        <div class="contact-feedback-block">
          <form action="#" method="post" id="cf">
            <div class="row">
              <div class="col-md-6">
                <div class="form-group">
                  <input type="text" class="form-control" id="fname" name="fname" placeholder="Name" required="">
                </div>
              </div>
              <div class="col-md-6">
                <div class="form-group">
                  <input type="text" class="form-control" placeholder="Company" name="company">
                </div>
              </div>
            </div>
            <div class="row">
              <div class="col-md-6">
                <div class="form-group">
                  <input type="email" class="form-control" id="email" name="email" placeholder="Email Address"
                    required="">
                </div>
              </div>
              <div class="col-md-6">
                <div class="form-group">
                  <input type="text" class="form-control" id="phone" name="phone" placeholder="Phone">
                </div>
              </div>
            </div>
            <div class="row">
              <div class="col-md-12">
                <div class="form-group">
                  <textarea class="form-control" id="msg" name="msg" rows="10"
                    placeholder="How can we help?"></textarea>
                </div>
              </div>
            </div>
            <div class="g-recaptcha" data-sitekey="6LdQE6EdAAAAAOLWdkqAhgqe7Bt49lzXHkIVPv1z"></div>

            <button type="submit" id="submit" name="submit" class="btn btn-primary">send a message</button>
          </form>
        </div>
      </div>
    </div>
  </div>
</div>
<!-- End Contact Page -->

<!-- Google Map -->
<div id="map-area">
  <div class="container p-0">
    <iframe
      src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d3602.695933899319!2d55.5706418!3d25.4484273!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x3ef5f923fde59efd%3A0x2870ef238b3171a1!2sS.MA%20Petrochem%20FZE!5e0!3m2!1sen!2sin!4v1719648131091!5m2!1sen!2sin"
      width="100%" height="450" style="border:0;" allowfullscreen="" loading="lazy"
      referrerpolicy="no-referrer-when-downgrade"></iframe>
  </div>
</div>
<!-- End Google Map -->


<script>
  document.addEventListener('DOMContentLoaded', function () {
    document.getElementById('cf').addEventListener('submit', function (e) {
      e.preventDefault();

      const formData = new FormData(this);

      const formObject = {};
      formData.forEach((value, key) => {
        formObject[key] = value;
      });

      fetch('contact_ajax.php', {
        method: 'POST',
        headers: {
          'Content-Type': 'application/json'
        },
        body: JSON.stringify(formObject)
      })
        .then(response => response.json())
        .then(data => {
          if (data.status === 'success') {
            alert('Message sent successfully.');
            document.getElementById('cf').reset();
          } else {
            alert('Error: ' + data.message);
          }
        })
        .catch(error => {
          console.error('Error:', error);
          alert('An error occurred while sending the message.');
        }).finally(() => {
          grecaptcha.reset();
        })
    });
  });

</script>

<?php include 'footer.php'; ?>